<?php
define('WP_INSTALLING', true);
//These three defines are required to allow us to use require_wp_db() to load the database class while being wp-content/wp-db.php aware
define('ABSPATH', dirname(dirname(__FILE__)).'/');
define('WPINC', 'wp-includes');
define('WP_CONTENT_DIR', ABSPATH . 'wp-content');

require_once('../wp-includes/compat.php');
require_once('../wp-includes/functions.php');
require_once('../wp-includes/classes.php');

if (!file_exists('../wp-config-sample.php'))
	wp_die('Jeg skal desv&aelig;rre bruge en wp-config-sample.php-fil, for at komme videre. Gen-upload venligst denne fil fra din WordPress-installation.');

$configFile = file('../wp-config-sample.php');

if ( !is_writable('../'))
	wp_die("Jeg kan desv&aelig;rre ikke skrive til mappen. Du bliver n&oslash;dt til at &aelig;ndre rettighederne for din WordPress-mappe eller lave wp-config.php manuelt.");

// Tjek om wp-config.php er blevet lavet
if (file_exists('../wp-config.php'))
	wp_die("<p>Filen 'wp-config.php' eksisterer allerede. Hvis du skal lave nogle konfigurationer i denne fil om, skal du slette den f&oslash;rst. Du kan pr&oslash;ve at <a href='install.php'>installere nu</a>.</p>");
// Tjek om wp-config.php findes over rodmappen
if (file_exists('../../wp-config.php'))
	wp_die("<p>Filen 'wp-config.php' eksisterer allerede et niveau over din WordPress-installation. Hvis du skal lave nogle konfigurationer i denne fil om, skal du slette den f&oslash;rst. Du kan pr&oslash;ve at <a href='install.php'>installere nu</a>.</p>");

if (isset($_GET['step']))
	$step = $_GET['step'];
else
	$step = 0;

function display_header(){
	header( 'Content-Type: text/html; charset=utf-8' );
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>WordPress &rsaquo; Setup Configuration File</title>
<link rel="stylesheet" href="<?php echo $admin_dir; ?>css/install.css" type="text/css" />

</head>
<body>
<h1 id="logo"><img alt="WordPress" src="images/wordpress-logo.png" /></h1>
<?php
}//end function display_header();

switch($step) {
	case 0:
		display_header();
?>

<p>Velkommen til WordPress. F&oslash;r vi starter, skal vi have nogle informationer om databasen. Du skal bruge f&oslash;lgende ting, f&oslash;r vi g&aring;r videre:</p> 
<ol> 
  <li>Databasenavn</li> 
  <li>Databasebrugernavn</li> 
  <li>Databasekodeord</li> 
  <li>Databasehost</li> 
  <li>Tabelpr&aelig;fiks (hvis du vil k&oslash;re mere end &eacute;n WordPress-blog i samme database) </li>
</ol> 
<p><strong>Hvis denne automatiske fildannelse ikke virker af en eller anden grund, skal du ikke bekymre dig. Det eneste den g&oslash;r, er at fylde databaseinformationer ind i en konfigurationsfil. Du kan ogs&aring; bare &aring;bne <code>wp-config-sample.php</code> i en teksteditor, udfylde dine informationer, og gemme som <code>wp-config.php</code>. </strong></p>
<p>Du har temmelig sikkert f&aring;et disse informationer af dit webhotel. Hvis du ikke har informationerne, skal du kontakte dem, f&oslash;r vi kan forts&aelig;tte. Hvis du er klar, s&aring; <a href="setup-config.php?step=1">lad os rulle</a>!</p>

<p class="step"><a href="setup-config.php?step=1" class="button">Lad os rulle!</a></p>
<?php
	break;

	case 1:
		display_header();
	?>
<form method="post" action="setup-config.php?step=2">
	<p>Nedenfor skal du indtaste dine databasedetaljer. Hvis du ikke kender dem, skal du kontakte dit webhotel. </p>
	<table class="form-table">
		<tr>
			<th scope="row"><label for="dbname">Databasenavn</label></th>
			<td><input name="dbname" id="dbname" type="text" size="25" value="wordpress" /></td>
			<td>The name of the database you want to run WP in. </td>
		</tr>
		<tr>
			<th scope="row"><label for="uname">Brugernavn</label></th>
			<td><input name="uname" type="text" size="25" value="brugernavn" /></td>
			<td>Dit brugernavn til MySQL</td>
		</tr>
		<tr>
			<th scope="row"><label for="pwd">Kodeord</label></th>
			<td><input name="pwd" type="text" size="25" value="kodeord" /></td>
			<td>...og dit kodeord til MySQL.</td>
		</tr>
		<tr>
			<th scope="row"><label for="dbhost">Database-host</label></th>
			<td><input name="dbhost" id="dbhost" type="text" size="25" value="localhost" /></td>
			<td>Med 99% sikkerhed skal du ikke &aelig;ndre noget her.</td> 
		</tr>
		<tr>
			<th scope="row"><label for="prefix">Tabelpr&aelig;fiks</label></th>
			<td><input name="prefix" id="prefix" type="text" id="prefix" value="wp_" size="25" /></td>
			<td>Hvis du vil k&oslash;re flere WordPress-blogs i samme database, skal du bruge forskellige pr&aelig;fiks.</td>
		</tr>
	</table>
	<p class="step"><input name="submit" type="submit" value="Send" class="button" /></p>
</form>
<?php
	break;

	case 2:
	$dbname  = trim($_POST['dbname']);
	$uname   = trim($_POST['uname']);
	$passwrd = trim($_POST['pwd']);
	$dbhost  = trim($_POST['dbhost']);
	$prefix  = trim($_POST['prefix']);
	if (empty($prefix)) $prefix = 'wp_';

	// Test the db connection.
	define('DB_NAME', $dbname);
	define('DB_USER', $uname);
	define('DB_PASSWORD', $passwrd);
	define('DB_HOST', $dbhost);

	// We'll fail here if the values are no good.
	require_wp_db();
	if ( !empty($wpdb->error) )
		wp_die($wpdb->error->get_error_message());

	$handle = fopen('../wp-config.php', 'w');

	foreach ($configFile as $line_num => $line) {
		switch (substr($line,0,16)) {
			case "define('DB_NAME'":
				fwrite($handle, str_replace("putyourdbnamehere", $dbname, $line));
				break;
			case "define('DB_USER'":
				fwrite($handle, str_replace("'usernamehere'", "'$uname'", $line));
				break;
			case "define('DB_PASSW":
				fwrite($handle, str_replace("'yourpasswordhere'", "'$passwrd'", $line));
				break;
			case "define('DB_HOST'":
				fwrite($handle, str_replace("localhost", $dbhost, $line));
				break;
			case '$table_prefix  =':
				fwrite($handle, str_replace('wp_', $prefix, $line));
				break;
			default:
				fwrite($handle, $line);
		}
	}
	fclose($handle);
	chmod('../wp-config.php', 0666);

	display_header();
?>
<p>All right sparky! You've made it through this part of the installation. WordPress can now communicate with your database. If you are ready, time now to&hellip;</p>

<p class="step"><a href="install.php" class="button">Run the install</a></p>
<?php
	break;
}
?>
</body>
</html>
