<?php
/**
 * Title: home
 * Slug: professio/home
 * Inserter: no
 */
?>
<!-- wp:cover {"url":"<?php echo esc_url( get_stylesheet_directory_uri() ); ?>/assets/images/StockSnap_ESDCTK2C7Z_web.png","hasParallax":true,"dimRatio":0,"isUserOverlayColor":true,"isDark":false,"sizeSlug":"full","align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60","left":"var:preset|spacing|40","right":"var:preset|spacing|40"},"margin":{"top":"0","bottom":"0"},"blockGap":"0"},"color":{"duotone":"var:preset|duotone|duo-secondary"}},"layout":{"type":"default"}} -->
<div class="wp-block-cover alignfull is-light has-parallax" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--60);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--60);padding-left:var(--wp--preset--spacing--40)"><div class="wp-block-cover__image-background size-full has-parallax" style="background-position:50% 50%;background-image:url(<?php echo esc_url( get_stylesheet_directory_uri() ); ?>/assets/images/StockSnap_ESDCTK2C7Z_web.png)"></div><span aria-hidden="true" class="wp-block-cover__background has-background-dim-0 has-background-dim"></span><div class="wp-block-cover__inner-container"><!-- wp:template-part {"slug":"header","area":"header"} /-->

<!-- wp:group {"tagName":"main","metadata":{"name":"Content"},"style":{"spacing":{"blockGap":"var:preset|spacing|70","padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30"}},"elements":{"link":{"color":{"text":"var:preset|color|contrast"}}}},"backgroundColor":"base","textColor":"contrast","layout":{"type":"constrained"}} -->
<main class="wp-block-group has-contrast-color has-base-background-color has-text-color has-background has-link-color" style="padding-top:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30)"><!-- wp:group {"metadata":{"name":"Hero section"},"align":"wide","style":{"spacing":{"blockGap":"var:preset|spacing|50"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group alignwide"><!-- wp:columns {"verticalAlignment":"bottom","align":"wide"} -->
<div class="wp-block-columns alignwide are-vertically-aligned-bottom"><!-- wp:column {"verticalAlignment":"bottom","width":"66.66%"} -->
<div class="wp-block-column is-vertically-aligned-bottom" style="flex-basis:66.66%"><!-- wp:heading {"level":1,"align":"wide","fontSize":"xxxx-large"} -->
<h1 class="wp-block-heading alignwide has-xxxx-large-font-size"><?php esc_html_e('Embark the learning odyssey with Nausicaä.', 'professio');?></h1>
<!-- /wp:heading --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"bottom","width":""} -->
<div class="wp-block-column is-vertically-aligned-bottom"><!-- wp:paragraph -->
<p><?php esc_html_e('— I\'m Nausicaä Rossi, a linguist based in Greece. Join me for unique experiences of language discovery, cultural enrichment, and effective communication.', 'professio');?></p>
<!-- /wp:paragraph -->

<!-- wp:spacer {"height":"var:preset|spacing|30"} -->
<div style="height:var(--wp--preset--spacing--30)" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:columns {"verticalAlignment":"top","align":"wide"} -->
<div class="wp-block-columns alignwide are-vertically-aligned-top"><!-- wp:column {"verticalAlignment":"top","width":""} -->
<div class="wp-block-column is-vertically-aligned-top"></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"top","width":"66.66%"} -->
<div class="wp-block-column is-vertically-aligned-top" style="flex-basis:66.66%"><!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/StockSnap_O0P6M3S1NQ_web.jpg","isUserOverlayColor":true,"gradient":"default-gradient","contentPosition":"top left","sizeSlug":"full","style":{"dimensions":{"aspectRatio":"4/3"},"spacing":{"padding":{"top":"var:preset|spacing|40","bottom":"var:preset|spacing|40","left":"var:preset|spacing|40","right":"var:preset|spacing|40"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-cover has-custom-content-position is-position-top-left" style="padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40)"><img class="wp-block-cover__image-background size-full" alt="" src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/StockSnap_O0P6M3S1NQ_web.jpg" data-object-fit="cover"/><span aria-hidden="true" class="wp-block-cover__background has-background-dim-100 has-background-dim wp-block-cover__gradient-background has-background-gradient has-default-gradient-gradient-background"></span><div class="wp-block-cover__inner-container"><!-- wp:image {"width":"112px","height":"112px","scale":"cover","sizeSlug":"full","linkDestination":"none","style":{"color":{"duotone":"var:preset|duotone|duo-secondary"}}} -->
<figure class="wp-block-image size-full is-resized"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/open-to-work.png" alt="" style="object-fit:cover;width:112px;height:112px"/></figure>
<!-- /wp:image --></div></div>
<!-- /wp:cover --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:group {"metadata":{"name":"Services"},"align":"wide","layout":{"type":"constrained","justifyContent":"left"}} -->
<div class="wp-block-group alignwide"><!-- wp:paragraph {"metadata":{"name":"Section caput"},"style":{"typography":{"textTransform":"uppercase","letterSpacing":"0.025em","fontStyle":"normal","fontWeight":"700"}},"fontSize":"small","fontFamily":"pt-root-ui"} -->
<p class="has-pt-root-ui-font-family has-small-font-size" style="font-style:normal;font-weight:700;letter-spacing:0.025em;text-transform:uppercase"><?php esc_html_e('What I do', 'professio');?></p>
<!-- /wp:paragraph -->

<!-- wp:spacer {"height":"var:preset|spacing|40"} -->
<div style="height:var(--wp--preset--spacing--40)" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|70","left":"var:preset|spacing|30"}}}} -->
<div class="wp-block-columns alignwide"><!-- wp:column {"width":"33.3%"} -->
<div class="wp-block-column" style="flex-basis:33.3%"><!-- wp:group {"metadata":{"name":"Service 1"},"style":{"spacing":{"blockGap":"0","padding":{"right":"var:preset|spacing|40"}}},"layout":{"type":"constrained","justifyContent":"left"}} -->
<div class="wp-block-group" style="padding-right:var(--wp--preset--spacing--40)"><!-- wp:paragraph {"metadata":{"name":"Icon"},"style":{"typography":{"lineHeight":"1.5"}},"fontSize":"xx-large"} -->
<p class="has-xx-large-font-size" style="line-height:1.5"><?php esc_html_e('🇮🇹', 'professio');?></p>
<!-- /wp:paragraph -->

<!-- wp:group {"metadata":{"name":"Course information"},"style":{"spacing":{"blockGap":"var:preset|spacing|40"}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"stretch"}} -->
<div class="wp-block-group"><!-- wp:heading -->
<h2 class="wp-block-heading"><?php esc_html_e('Learn Italian', 'professio');?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"metadata":{"name":"Course details"}} -->
<p><?php /* Translators: 1. is the start of a 'a' HTML element, 2. is the end of a 'a' HTML element */ 
echo sprintf( esc_html__( 'Immerse yourself in the beauty of this language and culture. %1$sEnroll the Journey%2$s » ', 'professio' ), '<a href="' . esc_url( '#' ) . '" data-type="post" data-id="24">', '</a>' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"33.3%"} -->
<div class="wp-block-column" style="flex-basis:33.3%"><!-- wp:group {"metadata":{"name":"Service 2"},"style":{"spacing":{"blockGap":"0","padding":{"right":"var:preset|spacing|40"}}},"layout":{"type":"constrained","justifyContent":"left"}} -->
<div class="wp-block-group" style="padding-right:var(--wp--preset--spacing--40)"><!-- wp:paragraph {"metadata":{"name":"Icon"},"style":{"typography":{"lineHeight":"1.5"}},"fontSize":"xx-large"} -->
<p class="has-xx-large-font-size" style="line-height:1.5"><?php esc_html_e('🏛️', 'professio');?></p>
<!-- /wp:paragraph -->

<!-- wp:group {"metadata":{"name":"Course information"},"style":{"spacing":{"blockGap":"var:preset|spacing|40"}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"stretch"}} -->
<div class="wp-block-group"><!-- wp:heading -->
<h2 class="wp-block-heading"><?php esc_html_e('Explore Latin', 'professio');?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"metadata":{"name":"Course details"}} -->
<p><?php /* Translators: 1. is the start of a 'a' HTML element, 2. is the end of a 'a' HTML element */ 
echo sprintf( esc_html__( 'Embark on a linguistic journey to the heart of ancient Rome. %1$sInitiate this Odyssey%2$s »', 'professio' ), '<a href="' . esc_url( '#' ) . '" data-type="post" data-id="20">', '</a>' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"33.3%"} -->
<div class="wp-block-column" style="flex-basis:33.3%"><!-- wp:group {"metadata":{"name":"Service 3"},"style":{"spacing":{"blockGap":"0","padding":{"right":"var:preset|spacing|40"}}},"layout":{"type":"constrained","justifyContent":"left"}} -->
<div class="wp-block-group" style="padding-right:var(--wp--preset--spacing--40)"><!-- wp:paragraph {"metadata":{"name":"Icon"},"style":{"typography":{"lineHeight":"1.5"}},"fontSize":"xx-large"} -->
<p class="has-xx-large-font-size" style="line-height:1.5"><?php esc_html_e('🇬🇷', 'professio');?></p>
<!-- /wp:paragraph -->

<!-- wp:group {"metadata":{"name":"Course information"},"style":{"spacing":{"blockGap":"var:preset|spacing|40"}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"stretch"}} -->
<div class="wp-block-group"><!-- wp:heading -->
<h2 class="wp-block-heading"><?php esc_html_e('Dive into Greek', 'professio');?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"metadata":{"name":"Course details"}} -->
<p><?php /* Translators: 1. is the start of a 'a' HTML element, 2. is the end of a 'a' HTML element */ 
echo sprintf( esc_html__( 'Discover Ancient Greece with the epics and philosophy. %1$sEmbark on an Adventure%2$s »', 'professio' ), '<a href="' . esc_url( '#' ) . '" data-type="post" data-id="18">', '</a>' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:group {"metadata":{"name":"Book Class"},"align":"wide","style":{"spacing":{"padding":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group alignwide" style="padding-top:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50)"><!-- wp:columns {"align":"wide"} -->
<div class="wp-block-columns alignwide"><!-- wp:column {"verticalAlignment":"top","width":""} -->
<div class="wp-block-column is-vertically-aligned-top"></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"top","width":"66.66%"} -->
<div class="wp-block-column is-vertically-aligned-top" style="flex-basis:66.66%"><!-- wp:heading {"fontSize":"xxx-large"} -->
<h2 class="wp-block-heading has-xxx-large-font-size"><?php esc_html_e('Book your Class', 'professio');?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php esc_html_e('Schedule a personalized language class or translation service based on my availability.', 'professio');?></p>
<!-- /wp:paragraph -->

<!-- wp:spacer {"height":"var:preset|spacing|40"} -->
<div style="height:var(--wp--preset--spacing--40)" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:buttons -->
<div class="wp-block-buttons"><!-- wp:button {"className":"is-style-fill"} -->
<div class="wp-block-button is-style-fill"><a class="wp-block-button__link wp-element-button"><?php esc_html_e('Contact Nausicaä', 'professio');?></a></div>
<!-- /wp:button -->

<!-- wp:button {"className":"is-style-outline"} -->
<div class="wp-block-button is-style-outline"><a class="wp-block-button__link wp-element-button"><?php esc_html_e('View Schedule', 'professio');?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:group {"metadata":{"name":"Resources"},"align":"full","style":{"elements":{"link":{"color":{"text":"var:preset|color|base"}}},"spacing":{"padding":{"bottom":"var:preset|spacing|80"}}},"textColor":"base","gradient":"detail-gradient","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull has-base-color has-detail-gradient-gradient-background has-text-color has-background has-link-color" style="padding-bottom:var(--wp--preset--spacing--80)"><!-- wp:columns {"verticalAlignment":"bottom","align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|70","left":"var:preset|spacing|30"}}}} -->
<div class="wp-block-columns alignwide are-vertically-aligned-bottom"><!-- wp:column {"verticalAlignment":"bottom","width":"30%"} -->
<div class="wp-block-column is-vertically-aligned-bottom" style="flex-basis:30%"><!-- wp:image {"aspectRatio":"3/4","scale":"cover","sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/StockSnap_Q6XLNSOUUO_web-edited-scaled.jpg" alt="" style="aspect-ratio:3/4;object-fit:cover"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"bottom","width":"3.3%"} -->
<div class="wp-block-column is-vertically-aligned-bottom" style="flex-basis:3.3%"></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"bottom","width":"66.66%"} -->
<div class="wp-block-column is-vertically-aligned-bottom" style="flex-basis:66.66%"><!-- wp:paragraph {"metadata":{"name":"Section caput"},"style":{"typography":{"textTransform":"uppercase","letterSpacing":"0.025em","fontStyle":"normal","fontWeight":"700"}},"fontSize":"small","fontFamily":"pt-root-ui"} -->
<p class="has-pt-root-ui-font-family has-small-font-size" style="font-style:normal;font-weight:700;letter-spacing:0.025em;text-transform:uppercase"><?php esc_html_e('Resources', 'professio');?></p>
<!-- /wp:paragraph -->

<!-- wp:heading {"fontSize":"xxx-large"} -->
<h2 class="wp-block-heading has-xxx-large-font-size"><?php esc_html_e('Expand Your Knowledge with Resources', 'professio');?></h2>
<!-- /wp:heading --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:spacer {"height":"var:preset|spacing|70"} -->
<div style="height:var(--wp--preset--spacing--70)" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|70"}}}} -->
<div class="wp-block-columns alignwide"><!-- wp:column {"verticalAlignment":"stretch","width":""} -->
<div class="wp-block-column is-vertically-aligned-stretch"><!-- wp:group {"metadata":{"name":"Titles"},"style":{"spacing":{"blockGap":"var:preset|spacing|30"}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"stretch"}} -->
<div class="wp-block-group"><!-- wp:heading {"level":3} -->
<h3 class="wp-block-heading"><?php esc_html_e('Italian Resources', 'professio');?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php esc_html_e('— Downloadable PDFs and online guides covering essential grammar rules, vocabulary, and language structures.', 'professio');?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:group {"metadata":{"name":"Links"},"style":{"spacing":{"blockGap":"var:preset|spacing|30"}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"stretch"}} -->
<div class="wp-block-group"><!-- wp:group {"metadata":{"name":"Link 1"},"style":{"spacing":{"blockGap":"var:preset|spacing|30"}},"layout":{"type":"flex","flexWrap":"nowrap","verticalAlignment":"bottom","justifyContent":"left"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"fontSize":"small"} -->
<p class="has-small-font-size"><?php /* Translators: 1. is the start of a 'font-awesome-icon' HTML element, 2. is the end of a 'font-awesome-icon' HTML element */ 
echo sprintf( esc_html__( '🔗%1$s%2$s', 'professio' ), '<font-awesome-icon icon="fa-regular fa-paperclip">', '</font-awesome-icon>' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"fontSize":"medium","fontFamily":"pt-root-ui"} -->
<p class="has-pt-root-ui-font-family has-medium-font-size"><?php /* Translators: 1. is the start of a 'a' HTML element, 2. is the end of a 'a' HTML element */ 
echo sprintf( esc_html__( '%1$sItalian Grammar Guides%2$s', 'professio' ), '<a href="' . esc_url( 'http://wordpress.org' ) . '" target="_blank" rel="noreferrer noopener">', '</a>' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:group {"metadata":{"name":"Link 2"},"style":{"spacing":{"blockGap":"var:preset|spacing|30"}},"layout":{"type":"flex","flexWrap":"nowrap","verticalAlignment":"bottom","justifyContent":"left"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"fontSize":"small"} -->
<p class="has-small-font-size"><?php /* Translators: 1. is the start of a 'font-awesome-icon' HTML element, 2. is the end of a 'font-awesome-icon' HTML element */ 
echo sprintf( esc_html__( '🔗%1$s%2$s', 'professio' ), '<font-awesome-icon icon="fa-regular fa-paperclip">', '</font-awesome-icon>' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"fontSize":"medium","fontFamily":"pt-root-ui"} -->
<p class="has-pt-root-ui-font-family has-medium-font-size"><?php /* Translators: 1. is the start of a 'a' HTML element, 2. is the end of a 'a' HTML element */ 
echo sprintf( esc_html__( '%1$sCultural Insight Articles%2$s', 'professio' ), '<a href="' . esc_url( 'http://wordpress.org' ) . '" target="_blank" rel="noreferrer noopener">', '</a>' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:group {"metadata":{"name":"Link 3"},"style":{"spacing":{"blockGap":"var:preset|spacing|30"}},"layout":{"type":"flex","flexWrap":"nowrap","verticalAlignment":"bottom","justifyContent":"left"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"fontSize":"small"} -->
<p class="has-small-font-size"><?php /* Translators: 1. is the start of a 'font-awesome-icon' HTML element, 2. is the end of a 'font-awesome-icon' HTML element */ 
echo sprintf( esc_html__( '🔗%1$s%2$s', 'professio' ), '<font-awesome-icon icon="fa-regular fa-paperclip">', '</font-awesome-icon>' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"fontSize":"medium","fontFamily":"pt-root-ui"} -->
<p class="has-pt-root-ui-font-family has-medium-font-size"><?php /* Translators: 1. is the start of a 'a' HTML element, 2. is the end of a 'a' HTML element */ 
echo sprintf( esc_html__( '%1$sConversation Practice Sheets%2$s', 'professio' ), '<a href="' . esc_url( 'http://wordpress.org' ) . '" target="_blank" rel="noreferrer noopener">', '</a>' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"stretch","width":""} -->
<div class="wp-block-column is-vertically-aligned-stretch"><!-- wp:group {"metadata":{"name":"Titles"},"style":{"spacing":{"blockGap":"var:preset|spacing|30"}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"stretch"}} -->
<div class="wp-block-group"><!-- wp:heading {"level":3} -->
<h3 class="wp-block-heading"><?php esc_html_e('Latin Materials', 'professio');?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php esc_html_e('— Recommendations for classical Latin texts with English translations for those exploring the beauty of ancient literature.', 'professio');?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:group {"metadata":{"name":"Links"},"style":{"spacing":{"blockGap":"var:preset|spacing|30"}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"stretch"}} -->
<div class="wp-block-group"><!-- wp:group {"metadata":{"name":"Link 1"},"style":{"spacing":{"blockGap":"var:preset|spacing|30"}},"layout":{"type":"flex","flexWrap":"nowrap","verticalAlignment":"bottom","justifyContent":"left"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"fontSize":"small"} -->
<p class="has-small-font-size"><?php /* Translators: 1. is the start of a 'font-awesome-icon' HTML element, 2. is the end of a 'font-awesome-icon' HTML element */ 
echo sprintf( esc_html__( '🔗%1$s%2$s', 'professio' ), '<font-awesome-icon icon="fa-regular fa-paperclip">', '</font-awesome-icon>' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"fontSize":"medium","fontFamily":"pt-root-ui"} -->
<p class="has-pt-root-ui-font-family has-medium-font-size"><?php /* Translators: 1. is the start of a 'a' HTML element, 2. is the end of a 'a' HTML element */ 
echo sprintf( esc_html__( '%1$sLatin Vocabulary Flashcards%2$s', 'professio' ), '<a href="' . esc_url( 'http://wordpress.org' ) . '" target="_blank" rel="noreferrer noopener">', '</a>' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:group {"metadata":{"name":"Link 2"},"style":{"spacing":{"blockGap":"var:preset|spacing|30"}},"layout":{"type":"flex","flexWrap":"nowrap","verticalAlignment":"bottom","justifyContent":"left"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"fontSize":"small"} -->
<p class="has-small-font-size"><?php /* Translators: 1. is the start of a 'font-awesome-icon' HTML element, 2. is the end of a 'font-awesome-icon' HTML element */ 
echo sprintf( esc_html__( '🔗%1$s%2$s', 'professio' ), '<font-awesome-icon icon="fa-regular fa-paperclip">', '</font-awesome-icon>' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"fontSize":"medium","fontFamily":"pt-root-ui"} -->
<p class="has-pt-root-ui-font-family has-medium-font-size"><?php /* Translators: 1. is the start of a 'a' HTML element, 2. is the end of a 'a' HTML element */ 
echo sprintf( esc_html__( '%1$sReading List of Classical Texts%2$s', 'professio' ), '<a href="' . esc_url( 'http://wordpress.org' ) . '" target="_blank" rel="noreferrer noopener">', '</a>' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:group {"metadata":{"name":"Link 3"},"style":{"spacing":{"blockGap":"var:preset|spacing|30"}},"layout":{"type":"flex","flexWrap":"nowrap","verticalAlignment":"bottom","justifyContent":"left"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"fontSize":"small"} -->
<p class="has-small-font-size"><?php /* Translators: 1. is the start of a 'font-awesome-icon' HTML element, 2. is the end of a 'font-awesome-icon' HTML element */ 
echo sprintf( esc_html__( '🔗%1$s%2$s', 'professio' ), '<font-awesome-icon icon="fa-regular fa-paperclip">', '</font-awesome-icon>' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"fontSize":"medium","fontFamily":"pt-root-ui"} -->
<p class="has-pt-root-ui-font-family has-medium-font-size"><?php /* Translators: 1. is the start of a 'a' HTML element, 2. is the end of a 'a' HTML element */ 
echo sprintf( esc_html__( '%1$sLatin Pronunciation Guides%2$s', 'professio' ), '<a href="' . esc_url( 'http://wordpress.org' ) . '" target="_blank" rel="noreferrer noopener">', '</a>' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"stretch","width":""} -->
<div class="wp-block-column is-vertically-aligned-stretch"><!-- wp:group {"metadata":{"name":"Titles"},"style":{"spacing":{"blockGap":"var:preset|spacing|30"}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"stretch"}} -->
<div class="wp-block-group"><!-- wp:heading {"level":3} -->
<h3 class="wp-block-heading"><?php esc_html_e('Greek Study Aids', 'professio');?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php esc_html_e('— A visual guide to the Greek alphabet, and 101 introductions to key philosophical concepts in Ancient Greek thought.', 'professio');?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:group {"metadata":{"name":"Links"},"style":{"spacing":{"blockGap":"var:preset|spacing|30"}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"stretch"}} -->
<div class="wp-block-group"><!-- wp:group {"metadata":{"name":"Link 1"},"style":{"spacing":{"blockGap":"var:preset|spacing|30"}},"layout":{"type":"flex","flexWrap":"nowrap","verticalAlignment":"bottom","justifyContent":"left"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"fontSize":"small"} -->
<p class="has-small-font-size"><?php /* Translators: 1. is the start of a 'font-awesome-icon' HTML element, 2. is the end of a 'font-awesome-icon' HTML element */ 
echo sprintf( esc_html__( '🔗%1$s%2$s', 'professio' ), '<font-awesome-icon icon="fa-regular fa-paperclip">', '</font-awesome-icon>' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"fontSize":"medium","fontFamily":"pt-root-ui"} -->
<p class="has-pt-root-ui-font-family has-medium-font-size"><?php /* Translators: 1. is the start of a 'a' HTML element, 2. is the end of a 'a' HTML element */ 
echo sprintf( esc_html__( '%1$sGreek Alphabet Chart%2$s', 'professio' ), '<a href="' . esc_url( 'http://wordpress.org' ) . '" target="_blank" rel="noreferrer noopener">', '</a>' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:group {"metadata":{"name":"Link 2"},"style":{"spacing":{"blockGap":"var:preset|spacing|30"}},"layout":{"type":"flex","flexWrap":"nowrap","verticalAlignment":"bottom","justifyContent":"left"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"fontSize":"small"} -->
<p class="has-small-font-size"><?php /* Translators: 1. is the start of a 'font-awesome-icon' HTML element, 2. is the end of a 'font-awesome-icon' HTML element */ 
echo sprintf( esc_html__( '🔗%1$s%2$s', 'professio' ), '<font-awesome-icon icon="fa-regular fa-paperclip">', '</font-awesome-icon>' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"fontSize":"medium","fontFamily":"pt-root-ui"} -->
<p class="has-pt-root-ui-font-family has-medium-font-size"><?php /* Translators: 1. is the start of a 'a' HTML element, 2. is the end of a 'a' HTML element */ 
echo sprintf( esc_html__( '%1$sPhilosophy Primers%2$s', 'professio' ), '<a href="' . esc_url( 'http://wordpress.org' ) . '" target="_blank" rel="noreferrer noopener">', '</a>' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:group {"metadata":{"name":"Link 3"},"style":{"spacing":{"blockGap":"var:preset|spacing|30"}},"layout":{"type":"flex","flexWrap":"nowrap","verticalAlignment":"bottom","justifyContent":"left"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"fontSize":"small"} -->
<p class="has-small-font-size"><?php /* Translators: 1. is the start of a 'font-awesome-icon' HTML element, 2. is the end of a 'font-awesome-icon' HTML element */ 
echo sprintf( esc_html__( '🔗%1$s%2$s', 'professio' ), '<font-awesome-icon icon="fa-regular fa-paperclip">', '</font-awesome-icon>' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"fontSize":"medium","fontFamily":"pt-root-ui"} -->
<p class="has-pt-root-ui-font-family has-medium-font-size"><?php /* Translators: 1. is the start of a 'a' HTML element, 2. is the end of a 'a' HTML element */ 
echo sprintf( esc_html__( '%1$sInteractive Mythology Quizzes%2$s', 'professio' ), '<a href="' . esc_url( 'http://wordpress.org' ) . '" target="_blank" rel="noreferrer noopener">', '</a>' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:spacer {"height":"var:preset|spacing|70"} -->
<div style="height:var(--wp--preset--spacing--70)" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:columns {"verticalAlignment":"bottom","align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|70"}}}} -->
<div class="wp-block-columns alignwide are-vertically-aligned-bottom"><!-- wp:column {"verticalAlignment":"bottom","width":""} -->
<div class="wp-block-column is-vertically-aligned-bottom"><!-- wp:buttons {"layout":{"type":"flex","justifyContent":"space-between"}} -->
<div class="wp-block-buttons"><!-- wp:button {"width":100} -->
<div class="wp-block-button has-custom-width wp-block-button__width-100"><a class="wp-block-button__link wp-element-button"><?php esc_html_e('Download all', 'professio');?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"bottom","width":""} -->
<div class="wp-block-column is-vertically-aligned-bottom"></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"bottom","width":""} -->
<div class="wp-block-column is-vertically-aligned-bottom"></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:group {"metadata":{"name":"Testimonials"},"align":"wide","style":{"spacing":{"blockGap":"var:preset|spacing|60"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group alignwide"><!-- wp:heading {"align":"wide"} -->
<h2 class="wp-block-heading alignwide"><?php esc_html_e('What My Students Say', 'professio');?></h2>
<!-- /wp:heading -->

<!-- wp:columns {"align":"wide"} -->
<div class="wp-block-columns alignwide"><!-- wp:column {"verticalAlignment":"stretch","width":""} -->
<div class="wp-block-column is-vertically-aligned-stretch"><!-- wp:group {"metadata":{"name":"Testimonial"},"style":{"spacing":{"padding":{"left":"var:preset|spacing|40","right":"0"}},"border":{"left":{"style":"dotted","width":"1px"},"top":[],"right":[],"bottom":[]},"layout":{"selfStretch":"fill","flexSize":null}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"stretch"}} -->
<div class="wp-block-group" style="border-left-style:dotted;border-left-width:1px;padding-right:0;padding-left:var(--wp--preset--spacing--40)"><!-- wp:paragraph -->
<p><?php esc_html_e('"Nausicaä\'s classes are a breath of fresh air - educational and entertaining. Learning Latin has never been more enjoyable!"', 'professio');?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"typography":{"fontStyle":"normal","fontWeight":"700"}}} -->
<p style="font-style:normal;font-weight:700"><?php esc_html_e('H. H.', 'professio');?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"stretch","width":""} -->
<div class="wp-block-column is-vertically-aligned-stretch"><!-- wp:group {"metadata":{"name":"Testimonial"},"style":{"spacing":{"padding":{"left":"var:preset|spacing|40","right":"0"}},"border":{"left":{"width":"1px","style":"dotted"},"top":[],"right":[],"bottom":[]},"layout":{"selfStretch":"fill","flexSize":null}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"stretch"}} -->
<div class="wp-block-group" style="border-left-style:dotted;border-left-width:1px;padding-right:0;padding-left:var(--wp--preset--spacing--40)"><!-- wp:paragraph -->
<p><?php esc_html_e('"Her translation work is flawless. Nausicaä helped me break language barriers in my project with precision and expertise."', 'professio');?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"typography":{"fontStyle":"normal","fontWeight":"700"}}} -->
<p style="font-style:normal;font-weight:700"><?php esc_html_e('A. B.', 'professio');?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"stretch","width":""} -->
<div class="wp-block-column is-vertically-aligned-stretch"><!-- wp:group {"metadata":{"name":"Testimonial"},"style":{"spacing":{"padding":{"left":"var:preset|spacing|40","right":"0"}},"border":{"left":{"width":"1px","style":"dotted"},"top":[],"right":[],"bottom":[]},"layout":{"selfStretch":"fill","flexSize":null}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"stretch"}} -->
<div class="wp-block-group" style="border-left-style:dotted;border-left-width:1px;padding-right:0;padding-left:var(--wp--preset--spacing--40)"><!-- wp:paragraph -->
<p><?php esc_html_e('"Nausicaä\'s classes are a breath of fresh air - educational and entertaining. Learning Latin has never been more enjoyable!"', 'professio');?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"typography":{"fontStyle":"normal","fontWeight":"700"}}} -->
<p style="font-style:normal;font-weight:700"><?php esc_html_e('C. D.', 'professio');?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:group {"metadata":{"name":"F.A.Q."},"align":"wide","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignwide"><!-- wp:columns {"align":"wide","style":{"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|60"}}} -->
<div class="wp-block-columns alignwide"><!-- wp:column {"width":"33.3%"} -->
<div class="wp-block-column" style="flex-basis:33.3%"><!-- wp:heading -->
<h2 class="wp-block-heading"><?php esc_html_e('Frequently Asked Questions', 'professio');?></h2>
<!-- /wp:heading --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"33.3%"} -->
<div class="wp-block-column" style="flex-basis:33.3%"><!-- wp:group {"metadata":{"name":"Detail wrapper 1"},"style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"stretch"}} -->
<div class="wp-block-group" style="margin-bottom:var(--wp--preset--spacing--60)"><!-- wp:heading {"level":3} -->
<h3 class="wp-block-heading"><?php esc_html_e('General Questions', 'professio');?></h3>
<!-- /wp:heading -->

<!-- wp:details -->
<details class="wp-block-details"><summary>How do I schedule a lesson with Nausicaä?</summary><!-- wp:paragraph {"fontSize":"small","fontFamily":"pt-root-ui"} -->
<p class="has-pt-root-ui-font-family has-small-font-size"><?php esc_html_e('Scheduling a lesson is easy! Simply navigate to the "View Schedule &amp; Book a Class" section on the website and choose a time that suits you.', 'professio');?></p>
<!-- /wp:paragraph --></details>
<!-- /wp:details -->

<!-- wp:details -->
<details class="wp-block-details"><summary>Are lessons available online or in person?</summary><!-- wp:paragraph {"fontSize":"small","fontFamily":"pt-root-ui"} -->
<p class="has-pt-root-ui-font-family has-small-font-size"><?php esc_html_e('Both options are available. You can opt for face-to-face lessons if you\'re local, or enjoy the convenience of online lessons from anywhere in the world.', 'professio');?></p>
<!-- /wp:paragraph --></details>
<!-- /wp:details --></div>
<!-- /wp:group -->

<!-- wp:group {"metadata":{"name":"Detail wrapper 2"},"style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"stretch"}} -->
<div class="wp-block-group" style="margin-bottom:var(--wp--preset--spacing--60)"><!-- wp:heading {"level":3} -->
<h3 class="wp-block-heading"><?php esc_html_e('Lesson Content and Style', 'professio');?></h3>
<!-- /wp:heading -->

<!-- wp:details -->
<details class="wp-block-details"><summary>How are language lessons structured?</summary><!-- wp:paragraph {"fontSize":"small","fontFamily":"pt-root-ui"} -->
<p class="has-pt-root-ui-font-family has-small-font-size"><?php esc_html_e('Lessons are tailored to your interests and skill level. We cover grammar, vocabulary, and cultural aspects through engaging and enjoyable activities.', 'professio');?></p>
<!-- /wp:paragraph --></details>
<!-- /wp:details -->

<!-- wp:details -->
<details class="wp-block-details"><summary>What materials are used in lessons?</summary><!-- wp:paragraph {"fontSize":"small","fontFamily":"pt-root-ui"} -->
<p class="has-pt-root-ui-font-family has-small-font-size"><?php esc_html_e('Lessons incorporate a variety of materials, including textbooks, interactive exercises, cultural resources, and more.', 'professio');?></p>
<!-- /wp:paragraph --></details>
<!-- /wp:details -->

<!-- wp:details -->
<details class="wp-block-details"><summary>Can Nausicaä help with exam preparation?</summary><!-- wp:paragraph {"fontSize":"small","fontFamily":"pt-root-ui"} -->
<p class="has-pt-root-ui-font-family has-small-font-size"><?php esc_html_e('Absolutely! Whether you\'re preparing for language exams or need assistance with academic goals, Isabel can provide targeted support.', 'professio');?></p>
<!-- /wp:paragraph --></details>
<!-- /wp:details --></div>
<!-- /wp:group -->

<!-- wp:group {"metadata":{"name":"Detail wrapper 3"},"style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"stretch"}} -->
<div class="wp-block-group" style="margin-bottom:var(--wp--preset--spacing--60)"><!-- wp:heading {"level":3} -->
<h3 class="wp-block-heading"><?php esc_html_e('Languages and Translation', 'professio');?></h3>
<!-- /wp:heading -->

<!-- wp:details -->
<details class="wp-block-details"><summary>Does Isabel offer translation services for documents or projects?</summary><!-- wp:paragraph {"fontSize":"small","fontFamily":"pt-root-ui"} -->
<p class="has-pt-root-ui-font-family has-small-font-size"><?php esc_html_e('Yes, Isabel provides expert translation services for documents, projects, and various content. Feel free to reach out for details and rates.', 'professio');?></p>
<!-- /wp:paragraph --></details>
<!-- /wp:details -->

<!-- wp:details -->
<details class="wp-block-details"><summary>Can I request translations in multiple languages?</summary><!-- wp:paragraph {"fontSize":"small","fontFamily":"pt-root-ui"} -->
<p class="has-pt-root-ui-font-family has-small-font-size"><?php esc_html_e('Certainly! Isabel is proficient in multiple languages and can handle translation requests in Italian, Spanish, English, and more.', 'professio');?></p>
<!-- /wp:paragraph --></details>
<!-- /wp:details --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"33.3%"} -->
<div class="wp-block-column" style="flex-basis:33.3%"><!-- wp:group {"metadata":{"name":"Detail wrapper 4"},"style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"stretch"}} -->
<div class="wp-block-group" style="margin-bottom:var(--wp--preset--spacing--60)"><!-- wp:heading {"level":3} -->
<h3 class="wp-block-heading"><?php esc_html_e('About Nausicaä', 'professio');?></h3>
<!-- /wp:heading -->

<!-- wp:details -->
<details class="wp-block-details"><summary>What inspired Nausicaä to become a language teacher?</summary><!-- wp:paragraph {"fontSize":"small","fontFamily":"pt-root-ui"} -->
<p class="has-pt-root-ui-font-family has-small-font-size"><?php esc_html_e('Nausicaä\'s passion for languages and diverse cultures inspired her to share the joy of language learning. She believes in making language education accessible and enjoyable.', 'professio');?></p>
<!-- /wp:paragraph --></details>
<!-- /wp:details -->

<!-- wp:details -->
<details class="wp-block-details"><summary>Nausicaä mentions a Master's thesis in Critical Discourse Analysis. Can you tell us more?</summary><!-- wp:paragraph {"fontSize":"small","fontFamily":"pt-root-ui"} -->
<p class="has-pt-root-ui-font-family has-small-font-size"><?php esc_html_e('Nausicaä is currently pursuing a Master\'s degree in Critical Discourse Analysis at the University of Milan. This academic pursuit enriches her understanding of language use and communication.', 'professio');?></p>
<!-- /wp:paragraph --></details>
<!-- /wp:details --></div>
<!-- /wp:group -->

<!-- wp:group {"metadata":{"name":"Detail wrapper 5"},"style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"stretch"}} -->
<div class="wp-block-group" style="margin-bottom:var(--wp--preset--spacing--60)"><!-- wp:heading {"level":3} -->
<h3 class="wp-block-heading"><?php esc_html_e('Accessing Resources', 'professio');?></h3>
<!-- /wp:heading -->

<!-- wp:details -->
<details class="wp-block-details"><summary>How can I access the language resources provided by Nausicaä?</summary><!-- wp:paragraph {"fontSize":"small","fontFamily":"pt-root-ui"} -->
<p class="has-pt-root-ui-font-family has-small-font-size"><?php /* Translators: 1. is a 'br' HTML element */ 
echo sprintf( esc_html__( 'The language resources are available in the "Resources" section on the website. Simply click on the respective language section to access downloadable PDFs, guides, and more.%1$s', 'professio' ), '<br>' ); ?></p>
<!-- /wp:paragraph --></details>
<!-- /wp:details -->

<!-- wp:details -->
<details class="wp-block-details"><summary>Are the resources suitable for beginners?</summary><!-- wp:paragraph {"fontSize":"small","fontFamily":"pt-root-ui"} -->
<p class="has-pt-root-ui-font-family has-small-font-size"><?php esc_html_e('Yes, the resources cater to learners of all levels, including beginners. They are designed to provide comprehensive support on your language learning journey.', 'professio');?></p>
<!-- /wp:paragraph --></details>
<!-- /wp:details --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:group {"metadata":{"name":"Latest Posts"},"align":"wide","style":{"spacing":{"blockGap":"var:preset|spacing|60"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group alignwide"><!-- wp:group {"metadata":{"name":"Section title"},"align":"wide","layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between","verticalAlignment":"bottom"}} -->
<div class="wp-block-group alignwide"><!-- wp:heading {"fontSize":"xxx-large"} -->
<h2 class="wp-block-heading has-xxx-large-font-size"><?php esc_html_e('Latest Posts', 'professio');?></h2>
<!-- /wp:heading --></div>
<!-- /wp:group -->

<!-- wp:query {"queryId":7,"query":{"perPage":3,"pages":0,"offset":0,"postType":"post","order":"desc","orderBy":"date","author":"","search":"","exclude":[],"sticky":"","inherit":false},"align":"wide"} -->
<div class="wp-block-query alignwide"><!-- wp:post-template {"style":{"spacing":{"blockGap":"var:preset|spacing|40"}},"layout":{"type":"grid","columnCount":3}} -->
<!-- wp:post-featured-image {"isLink":true,"aspectRatio":"1","width":"33.3%","style":{"color":[],"border":{"radius":"5px"}}} /-->

<!-- wp:group {"metadata":{"name":"Query Loop Copy"},"style":{"spacing":{"padding":{"bottom":"var:preset|spacing|60"},"blockGap":"var:preset|spacing|30"}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"stretch"}} -->
<div class="wp-block-group" style="padding-bottom:var(--wp--preset--spacing--60)"><!-- wp:group {"style":{"spacing":{"padding":{"right":"5%"},"blockGap":"0.5rem","margin":{"top":"var:preset|spacing|40","bottom":"var:preset|spacing|40"}}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"stretch"}} -->
<div class="wp-block-group" style="margin-top:var(--wp--preset--spacing--40);margin-bottom:var(--wp--preset--spacing--40);padding-right:5%"><!-- wp:post-date {"format":"M j, Y"} /-->

<!-- wp:post-title {"level":3,"isLink":true} /--></div>
<!-- /wp:group -->

<!-- wp:post-excerpt {"moreText":"Read more","showMoreOnNewLine":false,"excerptLength":20} /--></div>
<!-- /wp:group -->
<!-- /wp:post-template -->

<!-- wp:query-pagination -->
<!-- wp:query-pagination-previous /-->

<!-- wp:query-pagination-numbers /-->

<!-- wp:query-pagination-next /-->
<!-- /wp:query-pagination -->

<!-- wp:query-no-results -->
<!-- wp:paragraph {"placeholder":"Add text or blocks that will display when a query returns no results."} -->
<p><?php esc_html_e('Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'professio');?></p>
<!-- /wp:paragraph -->
<!-- /wp:query-no-results --></div>
<!-- /wp:query --></div>
<!-- /wp:group --></main>
<!-- /wp:group -->

<!-- wp:template-part {"slug":"footer","tagName":"footer","align":"full"} /--></div></div>
<!-- /wp:cover -->