/*
 * Decompiled with CFR 0.152.
 */
package roboguice.activity;

import android.app.LauncherActivity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import com.google.inject.Injector;
import roboguice.activity.event.OnActivityResultEvent;
import roboguice.activity.event.OnConfigurationChangedEvent;
import roboguice.activity.event.OnContentChangedEvent;
import roboguice.activity.event.OnContentViewAvailableEvent;
import roboguice.activity.event.OnCreateEvent;
import roboguice.activity.event.OnDestroyEvent;
import roboguice.activity.event.OnNewIntentEvent;
import roboguice.activity.event.OnPauseEvent;
import roboguice.activity.event.OnRestartEvent;
import roboguice.activity.event.OnResumeEvent;
import roboguice.activity.event.OnStartEvent;
import roboguice.activity.event.OnStopEvent;
import roboguice.application.RoboApplication;
import roboguice.event.EventManager;
import roboguice.inject.ContextScope;
import roboguice.inject.InjectorProvider;

public class RoboLauncherActivity
extends LauncherActivity
implements InjectorProvider {
    protected EventManager eventManager;
    protected ContextScope scope;

    protected void onCreate(Bundle savedInstanceState) {
        Injector injector = this.getInjector();
        this.eventManager = (EventManager)injector.getInstance(EventManager.class);
        this.scope = (ContextScope)injector.getInstance(ContextScope.class);
        this.scope.enter((Context)this);
        injector.injectMembers((Object)this);
        super.onCreate(savedInstanceState);
        this.eventManager.fire(new OnCreateEvent(savedInstanceState));
    }

    public void setContentView(int layoutResID) {
        super.setContentView(layoutResID);
        this.scope.injectViews();
        this.eventManager.fire(new OnContentViewAvailableEvent());
    }

    public void setContentView(View view, ViewGroup.LayoutParams params) {
        super.setContentView(view, params);
        this.scope.injectViews();
        this.eventManager.fire(new OnContentViewAvailableEvent());
    }

    public void setContentView(View view) {
        super.setContentView(view);
        this.scope.injectViews();
        this.eventManager.fire(new OnContentViewAvailableEvent());
    }

    public Object onRetainNonConfigurationInstance() {
        return this;
    }

    protected void onRestart() {
        this.scope.enter((Context)this);
        super.onRestart();
        this.eventManager.fire(new OnRestartEvent());
    }

    protected void onStart() {
        this.scope.enter((Context)this);
        super.onStart();
        this.eventManager.fire(new OnStartEvent());
    }

    protected void onResume() {
        this.scope.enter((Context)this);
        super.onResume();
        this.eventManager.fire(new OnResumeEvent());
    }

    protected void onPause() {
        super.onPause();
        this.eventManager.fire(new OnPauseEvent());
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.scope.enter((Context)this);
        this.eventManager.fire(new OnNewIntentEvent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onStop() {
        this.scope.enter((Context)this);
        try {
            this.eventManager.fire(new OnStopEvent());
        }
        finally {
            this.scope.exit((Context)this);
            super.onStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDestroy() {
        this.scope.enter((Context)this);
        try {
            this.eventManager.fire(new OnDestroyEvent());
        }
        finally {
            this.eventManager.clear((Context)this);
            this.scope.exit((Context)this);
            this.scope.dispose((Context)this);
            super.onDestroy();
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        Configuration currentConfig = this.getResources().getConfiguration();
        super.onConfigurationChanged(newConfig);
        this.eventManager.fire(new OnConfigurationChangedEvent(currentConfig, newConfig));
    }

    public void onContentChanged() {
        super.onContentChanged();
        this.eventManager.fire(new OnContentChangedEvent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        this.scope.enter((Context)this);
        try {
            this.eventManager.fire(new OnActivityResultEvent(requestCode, resultCode, data));
        }
        finally {
            this.scope.exit((Context)this);
        }
    }

    @Override
    public Injector getInjector() {
        return ((RoboApplication)this.getApplication()).getInjector();
    }
}

