/*
 * Decompiled with CFR 0.152.
 */
package roboguice.event;

import android.app.Application;
import android.content.Context;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import roboguice.event.EventListener;
import roboguice.event.javaassist.RuntimeSupport;
import roboguice.util.Ln;

@Singleton
public class EventManager {
    @Inject
    protected Provider<Context> contextProvider;
    protected Map<Context, Map<Class<?>, Set<EventListener<?>>>> registrations = new WeakHashMap();

    public boolean isEnabled() {
        return true;
    }

    public <T> void registerObserver(Class<T> event, EventListener listener) {
        this.registerObserver((Context)this.contextProvider.get(), event, listener);
    }

    public <T> void registerObserver(Object instance, Method method, Class<T> event) {
        this.registerObserver((Context)this.contextProvider.get(), instance, method, event);
    }

    public <T> void unregisterObserver(Class<T> event, EventListener<T> listener) {
        this.unregisterObserver((Context)this.contextProvider.get(), event, listener);
    }

    public <T> void unregisterObserver(Object instance, Class<T> event) {
        this.unregisterObserver((Context)this.contextProvider.get(), instance, event);
    }

    public void fire(Object event) {
        this.fire((Context)this.contextProvider.get(), event);
    }

    public <T> void registerObserver(Context context, Class<T> event, EventListener listener) {
        Set<EventListener<?>> observers;
        if (context instanceof Application) {
            throw new RuntimeException("You may not register event handlers on the Application context");
        }
        Map<Class<?>, Set<EventListener<?>>> methods = this.registrations.get(context);
        if (methods == null) {
            methods = new HashMap();
            this.registrations.put(context, methods);
        }
        if ((observers = methods.get(event)) == null) {
            observers = new HashSet();
            methods.put(event, observers);
        }
        observers.add(listener);
    }

    public <T> void registerObserver(Context context, Object instance, Method method, Class<T> event) {
        this.registerObserver(context, event, new ObserverMethodListener(instance, method));
    }

    public <T> void unregisterObserver(Context context, Class<T> event, EventListener<T> listener) {
        if (!this.isEnabled()) {
            return;
        }
        Map<Class<?>, Set<EventListener<?>>> methods = this.registrations.get(context);
        if (methods == null) {
            return;
        }
        Set<EventListener<?>> observers = methods.get(event);
        if (observers == null) {
            return;
        }
        Iterator<EventListener<?>> iterator = observers.iterator();
        while (iterator.hasNext()) {
            EventListener<?> registeredListener = iterator.next();
            if (registeredListener != listener) continue;
            iterator.remove();
            break;
        }
    }

    public <T> void unregisterObserver(Context context, Object instance, Class<T> event) {
        if (!this.isEnabled()) {
            return;
        }
        Map<Class<?>, Set<EventListener<?>>> methods = this.registrations.get(context);
        if (methods == null) {
            return;
        }
        Set<EventListener<?>> observers = methods.get(event);
        if (observers == null) {
            return;
        }
        Iterator<EventListener<?>> iterator = observers.iterator();
        while (iterator.hasNext()) {
            EventListener<?> listener = iterator.next();
            if (!(listener instanceof ObserverMethodListener)) continue;
            ObserverMethodListener observer = (ObserverMethodListener)listener;
            Object registeredInstance = observer.instanceReference.get();
            if (registeredInstance != instance) continue;
            iterator.remove();
            break;
        }
    }

    public void clear(Context context) {
        Map<Class<?>, Set<EventListener<?>>> methods = this.registrations.get(context);
        if (methods == null) {
            return;
        }
        this.registrations.remove(context);
        methods.clear();
    }

    public void fire(Context context, Object event) {
        if (!this.isEnabled()) {
            return;
        }
        Map<Class<?>, Set<EventListener<?>>> methods = this.registrations.get(context);
        if (methods == null) {
            return;
        }
        Set<EventListener<?>> observers = methods.get(event.getClass());
        if (observers == null) {
            return;
        }
        for (EventListener<?> observer : observers) {
            observer.onEvent(event);
        }
    }

    public static class ObserverMethodListener<T>
    implements EventListener<T> {
        protected String descriptor;
        protected Method method;
        protected WeakReference<Object> instanceReference;

        public ObserverMethodListener(Object instance, Method method) {
            this.instanceReference = new WeakReference<Object>(instance);
            this.method = method;
            this.descriptor = method.getName() + ':' + RuntimeSupport.makeDescriptor(method);
            method.setAccessible(true);
        }

        @Override
        public void onEvent(T event) {
            try {
                Object instance = this.instanceReference.get();
                if (instance != null) {
                    this.method.invoke(instance, event);
                } else {
                    Ln.w("trying to observe event %1$s on disposed context, consider explicitly calling EventManager.unregisterObserver", this.method.getName());
                }
            }
            catch (InvocationTargetException e) {
                Ln.e(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ObserverMethodListener that = (ObserverMethodListener)o;
            if (this.descriptor != null ? !this.descriptor.equals(that.descriptor) : that.descriptor != null) {
                return false;
            }
            Object thisInstance = this.instanceReference.get();
            Object thatInstance = that.instanceReference.get();
            return !(thisInstance == null ? thatInstance != null : !thisInstance.equals(thatInstance));
        }

        public int hashCode() {
            int result = this.descriptor != null ? this.descriptor.hashCode() : 0;
            Object thisInstance = this.instanceReference.get();
            result = 31 * result + (thisInstance != null ? thisInstance.hashCode() : 0);
            return result;
        }
    }

    public static class NullEventManager
    extends EventManager {
        @Override
        public boolean isEnabled() {
            return false;
        }
    }
}

