/*
 * Decompiled with CFR 0.152.
 */
package roboguice.event;

import android.content.Context;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import roboguice.event.EventManager;
import roboguice.event.Observes;

public class ObservesTypeListener
implements TypeListener {
    protected EventManager eventManager;
    protected Provider<Context> contextProvider;

    public ObservesTypeListener(Provider<Context> contextProvider, EventManager eventManager) {
        this.eventManager = eventManager;
        this.contextProvider = contextProvider;
    }

    public <I> void hear(TypeLiteral<I> iTypeLiteral, TypeEncounter<I> iTypeEncounter) {
        for (Class c = iTypeLiteral.getRawType(); c != Object.class; c = c.getSuperclass()) {
            for (Method method : c.getDeclaredMethods()) {
                this.findContextObserver(method, iTypeEncounter);
            }
            for (GenericDeclaration genericDeclaration : c.getInterfaces()) {
                for (Method method : ((Class)genericDeclaration).getDeclaredMethods()) {
                    this.findContextObserver(method, iTypeEncounter);
                }
            }
        }
    }

    protected <I> void findContextObserver(Method method, TypeEncounter<I> iTypeEncounter) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            Annotation[] annotationArray = parameterAnnotations[i];
            Class<?>[] parameterTypes = method.getParameterTypes();
            Class<?> parameterType = parameterTypes[i];
            for (Annotation annotation : annotationArray) {
                if (!annotation.annotationType().equals(Observes.class)) continue;
                this.registerContextObserver(iTypeEncounter, method, parameterType);
            }
        }
    }

    protected <I> void registerContextObserver(TypeEncounter<I> iTypeEncounter, Method method, Class parameterType) {
        this.checkMethodParameters(method);
        iTypeEncounter.register(new ContextObserverMethodInjector(this.contextProvider, this.eventManager, method, parameterType));
    }

    protected void checkMethodParameters(Method method) {
        if (method.getParameterTypes().length > 1) {
            throw new RuntimeException("Annotation @Observes must only annotate one parameter, which must be the only parameter in the listener method.");
        }
    }

    public static class ContextObserverMethodInjector<I>
    implements InjectionListener<I> {
        protected Provider<Context> contextProvider;
        protected EventManager eventManager;
        protected Method method;
        protected Class<?> event;

        public ContextObserverMethodInjector(Provider<Context> contextProvider, EventManager eventManager, Method method, Class<?> event) {
            this.contextProvider = contextProvider;
            this.eventManager = eventManager;
            this.method = method;
            this.event = event;
        }

        public void afterInjection(I i) {
            this.eventManager.registerObserver((Context)this.contextProvider.get(), i, this.method, this.event);
        }
    }
}

