/*
 * Decompiled with CFR 0.152.
 */
package roboguice.inject;

import android.app.Application;
import android.content.Context;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import roboguice.inject.ContextScope;
import roboguice.inject.InjectPreference;
import roboguice.inject.PreferenceMembersInjector;
import roboguice.inject.StaticTypeListener;

public class PreferenceListener
implements StaticTypeListener {
    protected Provider<Context> contextProvider;
    protected Application application;
    protected ContextScope scope;

    public PreferenceListener(Provider<Context> contextProvider, Application application, ContextScope scope) {
        this.contextProvider = contextProvider;
        this.application = application;
        this.scope = scope;
    }

    public <I> void hear(TypeLiteral<I> typeLiteral, TypeEncounter<I> typeEncounter) {
        for (Class c = typeLiteral.getRawType(); c != null; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || !field.isAnnotationPresent(InjectPreference.class)) continue;
                typeEncounter.register(new PreferenceMembersInjector(field, this.contextProvider, field.getAnnotation(InjectPreference.class), this.scope));
            }
        }
    }

    @Override
    public void requestStaticInjection(Class<?> ... types) {
        Class<?>[] arr$ = types;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            for (Class<?> c = arr$[i$]; c != null; c = c.getSuperclass()) {
                for (Field field : c.getDeclaredFields()) {
                    if (!Modifier.isStatic(field.getModifiers()) || !field.isAnnotationPresent(InjectPreference.class)) continue;
                    new PreferenceMembersInjector<Object>(field, this.contextProvider, field.getAnnotation(InjectPreference.class), this.scope).injectMembers(null);
                }
            }
        }
    }
}

