/**
 * Copyright (C) 2010-2011 eBusiness Information, Excilys Group
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed To in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.googlecode.androidannotations.generation;

import java.io.IOException;

import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;

import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.writer.PrologCodeWriter;

public class CodeModelGenerator {

	private final Filer filer;
	private final Messager messager;

	public CodeModelGenerator(Filer filer, Messager messager) {
		this.filer = filer;
		this.messager = messager;
	}

	public void generate(JCodeModel codeModel) throws IOException {

		SourceCodewriter sourceCodeWriter = new SourceCodewriter(filer, messager);

		PrologCodeWriter prologCodeWriter = new PrologCodeWriter(sourceCodeWriter, "DO NOT EDIT THIS FILE, IT HAS BEEN GENERATED USING AndroidAnnotations.\n");

		codeModel.build(prologCodeWriter, new ResourceCodeWriter(filer));
	}

}
