The Protein Structure Modules of BioJava
=====================================================

A tutorial for the protein structure modules of [BioJava](http://www.biojava.org)

## About
<table>
    <tr>
        <td>
            <img src="img/4hhb_jmol.png"/>
        </td>
        <td>
            The <i>protein structure modules</i> of BioJava provide an API that allows to 
            <ul>
                <li>Maintain local installations of PDB</li>
                <li>Load structures and manipulate them</li>
                <li>Perform standard analysis such as sequence and structure alignments</li>
                <li>Visualize structures</li>
            </ul>

            This tutorial provides an overview of the most important functionalities.
        </td>
    </tr>
</table>   

## Index

This tutorial is split into several chapters.


Chapter 1 - Quick [Installation](installation.md)

Chapter 2 - [First Steps](firststeps.md)

Chapter 3 - The [data model](structure-data-model.md) for the representation of macromolecular structures.

Chapter 4 - [Local installations](caching.md) of PDB

Chapter 5 - The [Chemical Component Dictionary](chemcomp.md)

Chapter 6 - How to [work with mmCIF/PDBx files](mmcif.md)

Chapter 7 - [SEQRES and ATOM records](seqres.md), mapping to Uniprot (SIFTs)

Chapter 8 - Protein [Structure Alignments](alignment.md)

Chapter 9 - [Biological Assemblies](bioassembly.md)

Chapter 10 - [External Databases](externaldb.md) like SCOP &amp; CATH

Chapter 11 - [Accessible Surface Areas](asa.md)

Chapter 12 - [Contacts within a chain and between chains](contact-map.md)

Chapter 13 - Finding all interfaces in crystal: [crystal contacts](crystal-contacts.md)

Chapter 14 - Protein Symmetry

Chapter 15 - Bonds

Chapter 16 - [Special Cases](special.md)

Chapter 17 - [Lists](lists.md) of PDB IDs and PDB [status information](lists.md).


### Author: 

[Andreas Prli&#263;](https://github.com/andreasprlic)

## Please cite

**BioJava: an open-source framework for bioinformatics in 2012**<br/>
*Andreas Prlic; Andrew Yates; Spencer E. Bliven; Peter W. Rose; Julius Jacobsen; Peter V. Troshin; Mark Chapman; Jianjiong Gao; Chuan Hock Koh; Sylvain Foisy; Richard Holland; Gediminas Rimsa; Michael L. Heuer; H. Brandstatter-Muller; Philip E. Bourne; Scooter Willis* <br/>
[Bioinformatics (2012) 28 (20): 2693-2695.](http://bioinformatics.oxfordjournals.org/content/28/20/2693.abstract) <br/>
[![doi](http://img.shields.io/badge/doi-10.1093%2Fbioinformatics%2Fbts494-blue.svg?style=flat)](http://bioinformatics.oxfordjournals.org/content/28/20/2693.abstract) [![pubmed](http://img.shields.io/badge/pubmed-22877863-blue.svg?style=flat)](http://www.ncbi.nlm.nih.gov/pubmed/22877863)

## License

The content of this tutorial is available under the [CC-BY](http://creativecommons.org/licenses/by/3.0/) license.

[view license](../license.md)



<!--automatically generated footer-->

---

Navigation:
[Home](../README.md)
| Book 3: The Protein Structure modules

Prev: [Book 2: The Alignment module](../alignment/README.md)

Next: [Book 4: The Genomics Module](../genomics/README.md)
