/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import twitter4j.JSONException;
import twitter4j.JSONObject;
import twitter4j.Logger;

public final class JSONObjectType {
    private static final Logger logger = Logger.getLogger(JSONObjectType.class);

    public static Type determine(JSONObject json) {
        if (!json.isNull("sender")) {
            return Type.SENDER;
        }
        if (!json.isNull("text")) {
            return Type.STATUS;
        }
        if (!json.isNull("direct_message")) {
            return Type.DIRECT_MESSAGE;
        }
        if (!json.isNull("delete")) {
            return Type.DELETE;
        }
        if (!json.isNull("limit")) {
            return Type.LIMIT;
        }
        if (!json.isNull("warning")) {
            return Type.STALL_WARNING;
        }
        if (!json.isNull("scrub_geo")) {
            return Type.SCRUB_GEO;
        }
        if (!json.isNull("friends")) {
            return Type.FRIENDS;
        }
        if (!json.isNull("event")) {
            try {
                String event = json.getString("event");
                if ("favorite".equals(event)) {
                    return Type.FAVORITE;
                }
                if ("unfavorite".equals(event)) {
                    return Type.UNFAVORITE;
                }
                if ("follow".equals(event)) {
                    return Type.FOLLOW;
                }
                if ("unfollow".equals(event)) {
                    return Type.UNFOLLOW;
                }
                if (event.startsWith("list")) {
                    if ("list_member_added".equals(event)) {
                        return Type.USER_LIST_MEMBER_ADDED;
                    }
                    if ("list_member_removed".equals(event)) {
                        return Type.USER_LIST_MEMBER_DELETED;
                    }
                    if ("list_user_subscribed".equals(event)) {
                        return Type.USER_LIST_SUBSCRIBED;
                    }
                    if ("list_user_unsubscribed".equals(event)) {
                        return Type.USER_LIST_UNSUBSCRIBED;
                    }
                    if ("list_created".equals(event)) {
                        return Type.USER_LIST_CREATED;
                    }
                    if ("list_updated".equals(event)) {
                        return Type.USER_LIST_UPDATED;
                    }
                    if ("list_destroyed".equals(event)) {
                        return Type.USER_LIST_DESTROYED;
                    }
                } else {
                    if ("user_update".equals(event)) {
                        return Type.USER_UPDATE;
                    }
                    if ("user_delete".equals(event)) {
                        return Type.USER_DELETE;
                    }
                    if ("user_suspend".equals(event)) {
                        return Type.USER_SUSPEND;
                    }
                    if ("block".equals(event)) {
                        return Type.BLOCK;
                    }
                    if ("unblock".equals(event)) {
                        return Type.UNBLOCK;
                    }
                    if ("retweeted_retweet".equals(event)) {
                        return Type.RETWEETED_RETWEET;
                    }
                    if ("favorited_retweet".equals(event)) {
                        return Type.FAVORITED_RETWEET;
                    }
                    if ("quoted_tweet".equals(event)) {
                        return Type.QUOTED_TWEET;
                    }
                }
            }
            catch (JSONException jsone) {
                try {
                    logger.warn("Failed to get event element: ", json.toString(2));
                }
                catch (JSONException jSONException) {}
            }
        } else if (!json.isNull("disconnect")) {
            return Type.DISCONNECTION;
        }
        return Type.UNKNOWN;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        SENDER,
        STATUS,
        DIRECT_MESSAGE,
        DELETE,
        LIMIT,
        STALL_WARNING,
        SCRUB_GEO,
        FRIENDS,
        FAVORITE,
        UNFAVORITE,
        FOLLOW,
        UNFOLLOW,
        USER_LIST_MEMBER_ADDED,
        USER_LIST_MEMBER_DELETED,
        USER_LIST_SUBSCRIBED,
        USER_LIST_UNSUBSCRIBED,
        USER_LIST_CREATED,
        USER_LIST_UPDATED,
        USER_LIST_DESTROYED,
        USER_UPDATE,
        USER_DELETE,
        USER_SUSPEND,
        BLOCK,
        UNBLOCK,
        DISCONNECTION,
        RETWEETED_RETWEET,
        FAVORITED_RETWEET,
        QUOTED_TWEET,
        UNKNOWN;

    }
}

