/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.media;

import twitter4j.auth.Authorization;
import twitter4j.auth.AuthorizationFactory;
import twitter4j.auth.OAuthAuthorization;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationContext;
import twitter4j.media.ImageUpload;
import twitter4j.media.ImgLyUpload;
import twitter4j.media.MediaProvider;
import twitter4j.media.MobypictureUpload;
import twitter4j.media.TwippleUpload;
import twitter4j.media.TwitterUpload;
import twitter4j.media.YFrogUpload;

public class ImageUploadFactory {
    private final Configuration conf;
    private final MediaProvider defaultMediaProvider;
    private final String apiKey;

    public ImageUploadFactory() {
        this(ConfigurationContext.getInstance());
    }

    public ImageUploadFactory(Configuration conf) {
        String mediaProvider = conf.getMediaProvider().toLowerCase();
        if ("twitter".equals(mediaProvider)) {
            this.defaultMediaProvider = MediaProvider.TWITTER;
        } else if ("imgly".equals(mediaProvider) || "img_ly".equals(mediaProvider)) {
            this.defaultMediaProvider = MediaProvider.IMG_LY;
        } else if ("twipple".equals(mediaProvider)) {
            this.defaultMediaProvider = MediaProvider.TWIPPLE;
        } else if ("yfrog".equals(mediaProvider)) {
            this.defaultMediaProvider = MediaProvider.YFROG;
        } else if ("mobypicture".equals(mediaProvider)) {
            this.defaultMediaProvider = MediaProvider.MOBYPICTURE;
        } else {
            throw new IllegalArgumentException("unsupported media provider:" + mediaProvider);
        }
        this.conf = conf;
        this.apiKey = conf.getMediaProviderAPIKey();
    }

    public ImageUpload getInstance() {
        return this.getInstance(this.defaultMediaProvider);
    }

    public ImageUpload getInstance(Authorization authorization) {
        return this.getInstance(this.defaultMediaProvider, authorization);
    }

    public ImageUpload getInstance(MediaProvider mediaProvider) {
        Authorization authorization = AuthorizationFactory.getInstance((Configuration)this.conf);
        return this.getInstance(mediaProvider, authorization);
    }

    public ImageUpload getInstance(MediaProvider mediaProvider, Authorization authorization) {
        if (!(authorization instanceof OAuthAuthorization)) {
            throw new IllegalArgumentException("OAuth authorization is required.");
        }
        OAuthAuthorization oauth = (OAuthAuthorization)authorization;
        if (mediaProvider == MediaProvider.TWITTER) {
            return new TwitterUpload(this.conf, oauth);
        }
        if (mediaProvider == MediaProvider.IMG_LY) {
            return new ImgLyUpload(this.conf, oauth);
        }
        if (mediaProvider == MediaProvider.TWIPPLE) {
            return new TwippleUpload(this.conf, oauth);
        }
        if (mediaProvider == MediaProvider.YFROG) {
            return new YFrogUpload(this.conf, oauth);
        }
        if (mediaProvider == MediaProvider.MOBYPICTURE) {
            return new MobypictureUpload(this.conf, this.apiKey, oauth);
        }
        throw new AssertionError((Object)"Unknown provider");
    }
}

