---
layout: post
title: Version 0.6
author: scribu
---

Got a lot of exciting news regarding wp-cli, so let's get right into it:

### The Reach

<blockquote class="twitter-tweet"><p>How To Install wp-cli on Dreamhost: you don't need to, it's already available. Just type "wp --help" in your shell. <a href="https://twitter.com/search/%23140charlongtutorials">#140charlongtutorials</a></p>&mdash; Ozh Richard (@ozh) <a href="https://twitter.com/ozh/status/243086032868896769" data-datetime="2012-09-04T20:40:01+00:00">September 4, 2012</a></blockquote>
<script src="//platform.twitter.com/widgets.js" charset="utf-8"></script>

Besides Dreamhost, it's used and recommended by the WordPress.com VIP team to all their clients.

Oh, and it's also used in a Juju Charm for [deploying WordPress in the cloud](http://jujucharms.com/charms/precise/wordpress). :D

### The `--require`

An interesting but easily overlooked feature is the new `--require` global parameter. Say you wrote a custom command called `chores` for yourself:

	WP_CLI::add_command( 'chores', 'My_Chores' );

	class My_Chores extends WP_CLI_Command {

		function do_laundry() {
			...
		}
		
		function wash_dishes() {
			...
		}
	}

Now, where do you put this code, so that WP-CLI can reach it? You could put it in a plugin, but if you have multiple WP installations, you'd have to install that plugin on each one. You could put it inside one of the WP-CLI directories, but that creates problems when you want to update. Here's what you could do instead:

	wp --require=/path/to/chores.php chores do_laundry

The `--require` parameter will load that PHP file at just the right time for the command to work as you'd expect.

### The Manual

The help system has been improved. When you do `wp help core config`, an actual man page will show up, with details about each parameter:

![wp-cli man-page](/assets/img/wp-cli-man-page.png)

Unfortunately, this doesn't work if you install WP-CLI via the PEAR package, because PEAR doesn't know how to handle them. :(

### The Changelog

Commands:

- added `wp post` and `wp post-meta`
- added `wp user-meta`
- added `wp blog create`
- added `wp export`
- added `wp theme install` and `wp theme update`
- added `wp transient`
- added `wp db optimize` and `wp db repair`
- added `wp db create`, `wp db drop` and `wp db reset`
- added `wp db import`
- added `wp core install_network`
- added `wp core update_db`
- added `--json` option to several subcommands
- added `--network` option to `wp plugin activate`
- fixed `wp plugin update`

Internals:

- fixed "out of memory" error
- misc bugfixes and optimizations

You can also browse the full list of [resolved issues](https://github.com/wp-cli/wp-cli/issues?milestone=4&state=closed).

### The Community

Most of the new commands you see in this release were actually implemented by other people.

Here are all the people that have contributed to this release: [andreascreten](http://github.com/andreascreten), [dwightjack](http://github.com/dwightjack), [getsource](http://github.com/getsource), [johnpbloch](http://github.com/johnpbloch), [joshstoik1](http://github.com/joshstoik1), [kidfiction](http://github.com/kidfiction), [marcoceppi](http://github.com/marcoceppi), [mgburns](http://github.com/mgburns), [mwilliamson](http://github.com/mwilliamson), [roelven](http://github.com/roelven), [scribu](http://github.com/scribu), [soulou](http://github.com/soulou), [tollmanz](http://github.com/tollmanz).

### The Future

The first thing I want to tackle next is revamping the install process. I'm also thinking of ditching PEAR entirely; it's just too limited: no man pages, no command auto-complete etc.

Beyond that, there are a lot of gaps to fill: `wp import`, `wp blog update`, `wp attachment` anyone?
