---
layout: post
title: Interactive WordPress Debugging
author: scribu
---

A new command [landed](https://github.com/wp-cli/wp-cli/pull/89) in WP-CLI a few days ago, called `shell`. It was inspired by an older project called [wpshell](http://code.trac.wordpress.org/browser/wpshell).

When you run `wp shell`, a <acronym title="read-eval-print-loop">REPL</acronym> will start, in which you can run any WordPress function.

The major advantage over `wp eval` and `wp eval-file` is that it's interactive: you immediately see the result of the previous command; it's also stored in the special `$_` variable, which you can use in the next command and so on.

Here's a contrived example session:

	scribu@air:~/wp/core$ wp shell
	Type "exit" to close session.
	wp> get_bloginfo('wpurl')
	'http://wp.dev/core'
	wp> $_ . '/feed/'
	'http://wp.dev/core/feed/'
	wp> exit
	scribu@air:~/wp/core$

`wp shell` will be available in the 0.7 release of WP-CLI, but if you want to try it out right now, clone the [latest version](https://github.com/wp-cli/wp-cli) from github. If you have suggestions for making it better, don't hesitate to open issues and pull requests. 
