---
layout: post
author: scribu
title: Version 0.11 has arrived.
---
It's been two months since the [last major release](/blog/version-0.10.html). We didn't want to wait any longer to show you all the goodies that we packed into this version.

### Import content from WXR files

A significant addition in this release is the [wp import](/commands/import/) command, which is the yin to [wp export](/commands/export/)'s yang.

It's an iteration on Automattic's [WordPress-CLI-Importer](https://github.com/Automattic/WordPress-CLI-Importer).

### Install multisite from scratch

Here's a little puzzle: How do you spin up a multisite install, when you already have a `wp-config.php` file with all the settings?

Run `wp core install` and then `wp core install-network`? No. Use a dummy `wp-config.php` file and then swap in the real one? Probably not. Learn to play jazz, impress Matt and then ask him to fix the multisite install process? Maybe later.

To trick WordPress into submission, you have to do a zillion little hacks, strewn throughout the loading process. We took care of this dirty work for you. Just run `wp core multisite-install`.

### Inline help

In previous versions, `wp help` called `man` internally. Besides not working on Windows, it also had the significant drawback that you had to use a separate tool to compile man pages.

In WP-CLI 0.11, we generate the docs on the fly, using the information from the [command PHPDoc](https://github.com/wp-cli/wp-cli/wiki/Commands-Cookbook#longdesc).

### Support for community packages

Remember how in the previous release we suggested using [the installer](/#install)? If you followed that recommendation, it should be very easy to install [community packages](https://github.com/wp-cli/wp-cli/wiki/Community-Packages) now.

### Changelog

Commands:

* added [wp import](/commands/import/) command
* added [wp core multisite-install](/commands/core/multisite-install/) command
* renamed `wp core install-network` to `wp core multisite-convert`
* added [wp network-meta](/commands/network-meta/) command
* renamed `wp blog` to `wp site`
* added `--force` flag to `wp plugin install` and `wp theme install`
* added `wp user get` subcommand
* added `--format=count` to `list` subcommands
* made `wp user` commands accept both user logins or user IDs.

Internals:

* added support for `@when before_wp_load` annotation
* added support for `apache_modules` config key
* show warning if WordPress version is too old
* support passing `--require=` multiple times
* deprecated `WP_CLI::add_man_dir()`

You can also browse the full list of [resolved issues](https://github.com/wp-cli/wp-cli/issues?milestone=10&state=closed) on Github.

Contributors to this release: [dangardner](https://github.com/dangardner), [danielbachhuber](https://github.com/danielbachhuber), [eugeneware](https://github.com/eugeneware), [jmslbam](https://github.com/jmslbam), [johnbillion](https://github.com/johnbillion), [MiteshShah](https://github.com/MiteshShah), [om4james](https://github.com/om4james), [scribu](https://github.com/scribu), [twratajczak](https://github.com/twratajczak), [Veered](https://github.com/Veered).
