---
layout: post
author: scribu
title: Version 0.12 released
---
It's been almost two months since the last major release. We have a few neat features to show you:

### `wp site list` command

I predict that this will turn out to be the most useful command for managing multisite installs, because you can use it to loop through all of them, directly from bash even:

	for url in $(wp site list --field=url)
	do
		echo "$url:"
		wp --url=$url post list
	done

### New `--field=` parameter

Notice the `--field=url` parameter I used above? It's available for all commands that display some information. A few examples:

	wp post get 123 --field=content

	wp user list --field=username

This will retrieve only the content of the post with ID 123 and nothing else.

### Experimental `--prompt` global parameter

This nifty little parameter changes the behaviour of commands when required arguments are not passed to a command. Instead of showing an error and exiting, it prompts you for the value of each argument. Try it out:

	wp theme scaffold --prompt

### Phar archives are back

They were originally introduced in [version 0.9](http://wp-cli.org/blog/version-0.9.html) and... ahem, naively abandoned in the next release with the introduction of the installer script.

The installer uses Composer, which has its own environmental requirements, but, more importantly, it has to fetch all of the packages WP-CLI depends on, which is both less reliable and slower than downloading a single file that contains everything.

This is particularly important in a continuous integration environment, like Travis CI, where you want to have your builds run as fast as possible and fail only due to failing tests, not due to a faulty internet connection.

So, phar archives can be downloaded from the [wp-cli/builds](https://github.com/wp-cli/builds/tree/gh-pages/phar) repository.

### Breaking changes

* `wp post get --format=content` was replaced with `wp post get --field=content`
* the `wp rewrite dump` command was replaced with `wp rewrite list`
* the `wp comment last` command was removed (use `wp comment list` instead)

### Other non-obvious changes

* `wp search-replace` no longer touches serialized objects ([#792][1])
* WP-CLI will display PHP errors on STDERR, even if XDebug is not installed ([#786][2])

### New commands

* `wp comment get`, `wp comment update` and `wp comment exists`
* `wp plugin get` and `wp theme get`
* `wp plugin search` and `wp theme search`
* `wp plugin is-installed` and `wp theme is-installed`
* `wp user add-cap`, `wp user remove-cap` and `wp user list-caps`

You can browse the full list of [resolved issues](https://github.com/WP-CLI/WP-CLI/issues?milestone=14&state=closed) on Github.

[1]: https://github.com/wp-cli/wp-cli/issues/792#issuecomment-25376430
[2]: https://github.com/wp-cli/wp-cli/pull/786

Contributors to this release: [c10b10](https://github.com/c10b10), [danielbachhuber](https://github.com/danielbachhuber), [getsource](https://github.com/getsource), [goldenapples](https://github.com/goldenapples), [jmslbam](https://github.com/jmslbam), [johnbillion](https://github.com/johnbillion), [joshbetz](https://github.com/joshbetz), [jtsternberg](https://github.com/jtsternberg), [mattes](https://github.com/mattes), [MattiaG](https://github.com/MattiaG), [mpeshev](https://github.com/mpeshev), [nikolay](https://github.com/nikolay), [nullvariable](https://github.com/nullvariable), [oknoway](https://github.com/oknoway), [Rarst](https://github.com/Rarst), [scribu](https://github.com/scribu), [smhmic](https://github.com/smhmic), [stianlik](https://github.com/stianlik), [thisislawatts](https://github.com/thisislawatts), [trepmal](https://github.com/trepmal), [westonruter](https://github.com/westonruter).
