---
layout: post
author: scribu
title: Version 0.13 released
---

It's been less than two months since the last major release of WP-CLI, and already we have a lot of goodies to show you.

### Global config files

If you create a `~/.wp-cli/config.yml` file, WP-CLI will read config values from that file, regardless of where you're running it from.

You can change the path to the global config file by setting the `WP_CLI_CONFIG_PATH` environment variable. That means that you can also disable the global config, like so:

	WP_CLI_CONFIG_PATH=/dev/null wp core install ...

The old `--config` global parameter is now deprecated.

### Setting command parameter values in config files

What's more, you can now define per-command config values. For example, if my config file looks like this:

	core install:
		admin_user: billy
		admin_email: billy@example.com

... when I run `wp core install`, I don't have to pass the `--admin_user` and `--admin_email` parameters again; they are read from the config file.

### Improved plugin test templates

We have simplified the process of [setting up and running plugin tests](https://github.com/wp-cli/wp-cli/wiki/Plugin-Unit-Tests) locally.

It fetches the test library from the new `develop.svn.wordpress.org` repository.

Also, the Travis build no longer depends on the Github mirror of WordPress.

### Improved downloads

Firstly, all HTTPS requests now use the more up-to-date SSL CA bundle from the Requests library, which should fix most certificate warnings.

Secondly, the timeout for `wp core download` has been increased to 10 minutes.

Thirdly, to extract the tarball, `wp core download` now uses the [PharData](http://us3.php.net/manual/en/class.phardata.php) class, instead of the `tar` binary. This should make it work in more environments, such as MinGW.

Finally, plugin and theme downloads are now cached. So, the first time you run `wp plugin install bbpress`, it will save the zip locally. The second time you run it, it won't download the zip again.

### Other improvements

Additions:

* added `--all` flag to `wp plugin deactivate`
* added `wp comment-meta` command
* added filtering to `wp plugin list` and `wp theme list`
* added `--match` and `--source` parameters to `wp rewrite list`
* added `--post_content` flag to `wp post generate`
* added `--skip-tests` flag to `wp scaffold plugin`
* added `--skip=image_resize` to `wp import`

Bug fixes:

* `wp core config` no longer escapes HTML characters in passwords
* `wp user create` no longer ignores the `--role` parameter
* `wp rewrite structure` correctly flushes rewrite rules
* `wp theme delete` now refuses to delete the active theme
* `wp scaffold post-type` now generates correct capitalization
* `wp plugin activate` now works correctly for network-only plugins
* `wp shell` now works correctly even if a plugin starts output buffering
* `wp core install --prompt` now correctly handles the `--url` parameter

Misc:

* removed `wp core init-tests` command ([context](https://github.com/wp-cli/wp-cli/pull/885))
* renamed `WP_CLI::add_action()` to `WP_CLI::add_hook()` ([context](https://github.com/wp-cli/wp-cli/pull/845))

You can browse the full list of [resolved issues](https://github.com/wp-cli/wp-cli/issues?milestone=19&page=1&state=closed) on Github.

Contributors to this release: [BoiteAWeb](https://github.com/BoiteAWeb), [ctayloroomphinc](https://github.com/ctayloroomphinc), [danielbachhuber](https://github.com/danielbachhuber), [dd32](https://github.com/dd32), [francescolaffi](https://github.com/francescolaffi), [jonathanbardo](https://github.com/jonathanbardo), [Kevinlearynet](https://github.com/Kevinlearynet), [leewillis77](https://github.com/leewillis77), [nickdaugherty](https://github.com/nickdaugherty), [QWp6t](https://github.com/QWp6t), [rodrigoprimo](https://github.com/rodrigoprimo), [ryanduff](https://github.com/ryanduff), [scribu](https://github.com/scribu), [simonwheatley](https://github.com/simonwheatley), [tiagohillebrandt](https://github.com/tiagohillebrandt), [tlovett1](https://github.com/tlovett1), [wojsmol](https://github.com/wojsmol).
