---
layout: post
author: scribu
title: Version 0.14 released
---

I'm pleased to present the first release of WP-CLI in 2014, coincidentally called 0.14.0. Let's get right into it.

### Automatically detect WordPress in a subdirectory

Having [WordPress in a subdirectory][subdir] is a great way keep your code repository clean.

Until now, you had to explicitly tell WP-CLI how to find it, either by using the `--path=` parameter, or by creating a `wp-cli.yml` file in the root directory. With version 0.14, it will find it automatically.

To make this not-common-enough scenario work, we had to once again call upon the [dark powers of `eval()`][eval].

### Protection against running as root

If you try to run a WP-CLI command as the superuser, WP-CLI will refuse to run. In production environemnts, most of the commands should actually be run under the same user as the web server. But, in general, running commands as root is a bad idea.

For example, if you run `wp media regenerate` as `root`, then the newly created thumbnail files will naturally be owned by `root`. If the web server is running under the `www-data` user, it won't be able to change these files (unless they're globally writable, which is less secure). So, the correct command would be `sudo -u www-data wp media regenerate`.

If you trigger this protection, you will also receive instructions about how to disable it.

### `--skip-plugins` global flag

Ever used WP-CLI to install a plugin that broke WP-CLI? Well, now there's a 100% sure way to deactivate it: `wp --skip-plugins plugin deactivate naughty-plugin`.

You can also skip only particular plugins: `wp --skip-plugins=admin-blocker,complex-beast`.

<div class="announcement breaking" markdown="1">

### <i class="icon-attention"></i> Breaking changes

* `wp term create`, `wp term update`, `wp term get` and `wp term delete` now accept the taxonomy as the first parameter, just like all the other term subcommands

</div>

<div class="announcement changes" markdown="1">

### <i class="icon-info-circled"></i> Other changes

* added `wp post url`, `wp comment url` and `wp site url` subcommands
* added `wp theme enable` and `wp theme disable` subcommands for multisite installs
* added `wp term generate` subcommand
* added `--recurse-objects` flag to `wp search-replace`
* added `--locale` flag to `wp core update`
* `wp core download` now caches WordPress archives
* all `wp user` subcommands now accept user emails as parameters (besides IDs and usernames)
* `wp option` and `wp *-meta` subcommands can now read values from STDIN
* `wp import` now accepts multiple files
* `wp db export` now accepts all parameters that `mysqldump` accepts
* `wp export` now uses a better backend developed by [Nikolay Bachiyski](https://github.com/nb/) (see [#525](https://github.com/wp-cli/wp-cli/pull/525))
* plugin slugs passed to `wp plugin` subcommands are now always case-sensitive
* fixed JetPack activation
* fixed `wp core is-installed` for multisite
* fixed `--max_depth` parameter for `wp post generate`
* fixed `--role` parameter for `wp user generate`
* fixed issue where `wp user import-csv` would pick up previous user IDs
* fixed issue with progress bar calling `tput` too often
* execution is now aborted if too many positional parameters are passed or if an unknown associative parameter is passed

You can browse the full list of [resolved issues](https://github.com/wp-cli/wp-cli/issues?milestone=20&state=closed) on Github.

</div>

Contributors to this release: [bartaakos](https://github.com/bartaakos), [boonebgorges](https://github.com/boonebgorges), [danielbachhuber](https://github.com/danielbachhuber), [eliorivero](https://github.com/eliorivero), [francescolaffi](https://github.com/francescolaffi), [itsananderson](https://github.com/itsananderson), [Japh](https://github.com/Japh), [jmslbam](https://github.com/jmslbam), [johnbillion](https://github.com/johnbillion), [mboynes](https://github.com/mboynes), [mgburns](https://github.com/mgburns), [nb](https://github.com/nb), [rodrigoprimo](https://github.com/rodrigoprimo), [scribu](https://github.com/scribu), [sibprogrammer](https://github.com/sibprogrammer), [simonwheatley](https://github.com/simonwheatley), [SpikesDivZero](https://github.com/SpikesDivZero), [westonruter](https://github.com/westonruter), [ziz](https://github.com/ziz)

[subdir]: http://codex.wordpress.org/Giving_WordPress_Its_Own_Directory
[eval]: https://github.com/wp-cli/wp-cli/blob/v0.14.0/php/WP_CLI/Runner.php#L76-95
