---
layout: post
author: scribu
title: Version 0.15 released
---
A new version of WP-CLI is here. The highlights:

### Manage more things

There are brand new top-level commands for dealing with more types of objects in a WordPress install:

* `wp super-admin` for managing caped admins on multisite
* `wp menu` for managing navigation menus
* `wp widget` and `wp sidebar` for managing widgets and sidebars
* `wp theme mod` for managing theme mods

### Exporting only particular database tables

With the new `wp db tables` subcommand, you can generate a list of database tables, which you can pass to the `wp db export` command, like so:

	wp db export --tables=$(wp db tables --url=sub.example.com | tr '\n' ',')

Composability is beautiful.

### Arbitrary command nesting

Up until now, you could only have top-level commands, like `wp search-replace` and second-level subcommands, like `wp core install`. Now, you can have commands at any depth, such as `wp post meta update`.

This capability is especially useful to third-party commands, such as [wp-cli-buddypress][bp].

### Revamped bash completions

Bash completions are now a bit smarter: besides auto-completing positional parameters like `--dbname=`, it will also suggest file names, if the subcommand you're writing out expects a file name.

Note that after updating `wp-cli.phar`, you will also have to update the [wp-completion.bash][bash] file.

### Other changes

* added support for WordPress 3.9 and bumped minimum required version to 3.5
* disable KSES filtering when a user is not explicitly set
* allow defining `skip-plugins` and `wp core config --extra-php` in the `wp-cli.yml` file
* added `wp role reset` subcommand
* added `wp transient delete-all` and `wp transient delete-expired` subcommands
* `wp core config`: added `--skip-check` flag
* `wp core is-installed`: added `--network` flag
* `wp user create`: added `--send-email` flag
* `wp user delete`: added `--network` flag
* `wp option add`: added `--autoload=` parameter
* `wp search-replace`: now works with tables that have a composite primary key
* `wp post create`: fixed handling of `--post_category=` parameter
* `wp eval-file`: allow passing arbitrary arguments to the file

You can browse the full list of [resolved issues](https://github.com/wp-cli/wp-cli/issues?milestone=21&page=1&state=closed) on Github.

Contributors to this release: [clemens-tolboom](https://github.com/clemens-tolboom), [danielbachhuber](https://github.com/danielbachhuber), [francescolaffi](https://github.com/francescolaffi), [itsananderson](https://github.com/itsananderson), [johnpbloch](https://github.com/johnpbloch), [mattheu](https://github.com/mattheu), [nyordanov](https://github.com/nyordanov), [Rarst](https://github.com/Rarst), [robertboloc](https://github.com/robertboloc), [rodrigoprimo](https://github.com/rodrigoprimo), [sboisvert](https://github.com/sboisvert), [scribu](https://github.com/scribu), [szepeviktor](https://github.com/szepeviktor), [trepmal](https://github.com/trepmal). 

### Survey

We'd like to know how people are using WP-CLI so we set up a [quick survey][survey] (just 5 questions). We'd appreciate it if you would fill it out. The results will be posted here, in a separate blog post.

[bash]: https://raw.githubusercontent.com/wp-cli/wp-cli/master/utils/wp-completion.bash
[bp]: https://github.com/boonebgorges/wp-cli-buddypress
[survey]: https://docs.google.com/forms/d/1oW7GHAoE4e1YMVWvbQlz3n_lziDdHQUlKeMm4x0_6XA/viewform
