---
layout: post
author: danielbachhuber
title: Version 0.16 released
---

Just in time for your crazy load of summer projects, we have a new version of WP-CLI for you. Here's what's new.

### Manage WP-Cron

Confused by how WP-Cron is acting? Wonder no more!

See all scheduled cron events:

	$ wp cron event list
	+-----------------------------+---------------------+-----------------------+------------+
	| hook                        | next_run_gmt        | next_run_relative     | recurrence |
	+-----------------------------+---------------------+-----------------------+------------+
	| wp_version_check            | 2014-07-01 04:05:59 | 3 hours 50 minutes    | 12 hours   |
	| wp_update_plugins           | 2014-07-01 04:05:59 | 3 hours 50 minutes    | 12 hours   |
	| wp_update_themes            | 2014-07-01 04:05:59 | 3 hours 50 minutes    | 12 hours   |
	| update_network_counts       | 2014-07-01 04:06:05 | 3 hours 50 minutes    | 12 hours   |
	| wp_maybe_auto_update        | 2014-07-01 07:51:00 | 7 hours 35 minutes    | 12 hours   |
	| wp_scheduled_delete         | 2014-07-01 16:06:05 | 15 hours 50 minutes   | 1 day      |
	+-----------------------------+---------------------+-----------------------+------------+

Run a specific cron event:

	$ wp cron event run wp_scheduled_delete
	Success: Successfully executed the cron event 'wp_scheduled_delete'

Inspect registered cron schedules:

	$ wp cron schedule list
	+------------+-------------+----------+
	| name       | display     | interval |
	+------------+-------------+----------+
	| hourly     | Once Hourly | 3600     |
	| twicedaily | Twice Daily | 43200    |
	| daily      | Once Daily  | 86400    |
	+------------+-------------+----------+

Take a look at `wp help cron` for the full details.

### Verify core checksums

To help you confirm the sanctity of your WordPress install, `wp core verify-checksums` fetches checksums from WordPress.org and compares them to that of your local files.

For the layperson, a checksum is a calculation of a file's contents using the MD5 algorithm. To generate a checksum is to produce a 32 digit hexadecimal number that represents the file's state. WP-CLI's `wp core verify-checksums` command downloads WordPress.org's reported checksums for each core file, and then compares those values to the checksum it calculates for each local file. If the values differ, then it's an indication the file's contents differ from what they should be.

A successful check will look like this:

	$ wp core verify-checksums
	Success: WordPress install verifies against checksums.

If any core files have been modified, you'll see something like this:

	$ wp core verify-checksums
	Warning: File doesn't verify against checksum: readme.html
	Error: WordPress install doesn't verify against checksums.

### A new look

[WP-CLI.org](http://wp-cli.org) received a much-appreciated fresh coat of paint. [Share the love on Twitter](https://twitter.com/intent/tweet?text=Love%20the%20fresh%20coat%20of%20paint%2C%20%40wpcli%21%20Check%20it%20out%3A%20http%3A%2F%2Fwp-cli.org) (or report any bugs in the [issue tracker](https://github.com/wp-cli/wp-cli/issues/new)).

### Other changes

Additions:

* `wp * meta list`: list meta values for a given post, comment, or user
* `wp * meta delete`: supports passing a value to match against, mimicking core behavior
* `wp post generate`: the `--post_author=<post-author>` argument supports user ID, login, or email address
* `wp scaffold plugin`: includes a sample readme.txt
* `wp (theme|plugin) install`: creates parent directories if they don't yet exist
* `wp user create`: added `--first_name=<first-name>` and `--last_name=<last-name>` parameters
* `wp user import-csv`: a `--skip-update` flag will prevent updating existing users
* Clearer, more helpful messages and warnings across the board

Fixes:

* Plugins with `Network: True` header activate without throwing a warning on non-multisite installs
* Disabled commands no longer appear in usage docs
* Autocompletion file works properly for both bash and ZSH
* `wp core update`: can update directly from a ZIP file

You can browse the full list of [resolved issues](https://github.com/wp-cli/wp-cli/issues?milestone=23&page=1&state=closed) on Github.

Contributors to this release: [boonebgorges](https://github.com/boonebgorges), [danielbachhuber](https://github.com/danielbachhuber), [jmslbam](https://github.com/jmslbam), [johnbillion](https://github.com/johnbillion), [joshlevinson](https://github.com/joshlevinson), [mboynes](https://github.com/mboynes), [rodrigoprimo](https://github.com/rodrigoprimo), [ryanduff](https://github.com/ryanduff), [scribu](https://github.com/scribu), [szepeviktor](https://github.com/szepeviktor), [westonruter](https://github.com/westonruter)
