---
layout: post
author: danielbachhuber
title: Version 0.17 released
---

For the fourth WP-CLI release of 2014, we have a number of enhancements that will make you go "oooh" and "ahhh".

### Speed!!!

Use `wp search-replace` while migrating large databases? You should submit a pull request to WP-CLI with your newly-found free time :)

Historically, this command performed the search and replace operation in PHP, as to not break arrays and objects serialized in the database.

Now, this command performs a check to see if there is any serialized data in the column it's about to transform. If there isn't, the command will perform a SQL search and replace. If there is serialized data, the command falls back to PHP search and replace.

One happy developer reported this new approach took 20 minutes on a large test database, compared to 8-12 hours previously — a 3,000% performance increase.

### Manage languages

WordPress 4.0 lets a user pick a language on installation, or later through General Settings. WP-CLI now lets you see available languages, and install / activate one of your choosing.

    $ wp core language list
    +----------+-----------------------+---------------------+-------------+---------------------+
    | language | english_name          | native_name         | status      | updated             |
    +----------+-----------------------+---------------------+-------------+---------------------+
    | az       | Azerbaijani           | Azərbaycan dili     | installed   | 2014-09-06 09:50:59 |
    | bs_BA    | Bosnian               | Bosanski            | uninstalled | 2014-09-04 15:47:16 |
    | ca       | Catalan               | Català              | uninstalled | 2014-09-07 17:14:09 |
    | cy       | Welsh                 | Cymraeg             | uninstalled | 2014-09-04 16:43:49 |
    | da_DK    | Danish                | Dansk               | uninstalled | 2014-09-04 20:59:54 |
    | de_DE    | German                | Deutsch             | uninstalled | 2014-09-05 15:23:15 |
    | en_AU    | English (Australia)   | English (Australia) | uninstalled | 2014-09-06 00:56:37 |
    | en_GB    | English (UK)          | English (UK)        | installed   | 2014-09-04 08:52:52 |
    | en_CA    | English (Canada)      | English (Canada)    | uninstalled | 2014-09-05 00:31:07 |
    | en_PR    | English (Pirate)      | English (Pirate)    | active      | 2014-09-05 00:31:07 |

### Checking updates

v0.17.0 introduces two commands for checking for updates.

For WP-CLI:

    $ wp cli version
    WP-CLI 0.16.0
    $ wp cli check-update
    +---------+-------------+-------------------------------------------------------------------------------+
    | version | update_type | package_url                                                                   |
    +---------+-------------+-------------------------------------------------------------------------------+
    | 0.17.0  | minor       | https://github.com/wp-cli/wp-cli/releases/download/v0.17.0/wp-cli.phar        |
    +---------+-------------+-------------------------------------------------------------------------------+

Or for WordPress core:

    $ wp core version
    3.9.1
    $ wp core check-update
    +---------+-------------+-------------------------------------------+
    | version | update_type | package_url                               |
    +---------+-------------+-------------------------------------------+
    | 4.0     | major       | https://wordpress.org/wordpress-4.0.zip   |
    | 3.9.2   | minor       | https://wordpress.org/wordpress-3.9.2.zip |
    +---------+-------------+-------------------------------------------+

### php-cli-tools v0.10.0/1

In the recent past, we took over maintainership of [php-cli-tools](https://github.com/wp-cli/php-cli-tools). WP-CLI makes use of many of its features, so we were honored to be considered when [jlogsdon](https://github.com/jlogsdon) was looking for a new home for the project.

During the course of this release cycle, we released two new versions of php-cli-tools, v0.10.0 and v0.10.1. Together, the changeset includes:

* `cli\prompt()` includes an option to hide input (useful for passwords, etc.).
* `cli\Table` auto-wraps contents of a cell based on TTY width.
* `SHELL_PIPE` environment variable can be defined for determining whether TTY is piped.
* Fix: Add fallback for `mb_strlen()` when PHP mbstring extension isn't enabled (bug introduced in v0.9.5)
* Fix: `cli\Colors::length()` now returns correct lengths for colorized strings

Going forward, php-cli-tools' release cycle will be tied to WP-CLI's — and WP-CLI will run php-cli-tools `dev-master` to help test out new features.

### Other changes

Additions:

* Full compatibility with WordPress 4.0.
* `wp core update`: Caches package locally, for improved performance when updating multiple sites on the same server.
* `wp import`: Import a directory of WXR files.
* `wp scaffold package-tests`: Use WP-CLI's Behat framework to add functional tests to your own command. [See wiki for implementation details](https://github.com/wp-cli/wp-cli/wiki/Package-Functional-Tests).
* `wp search-replace`: Supports `--quiet` flag for verbosity.
* `wp term list`: List terms for multiple taxonomies.
* `wp user import-csv`: Create users from a remote CSV (e.g. stored in Dropbox or Google Drive).
* `WP_CLI::launch_self()`: Optionally return the execution output (e.g. `STDOUT` or `STDERR`). Introduces a new `\WP_CLI\Process` class for executing system commands.
* Uploads directory will be created when installing core, if it doesn't exist.
* If a parameter missing, the description for the parameter will be shown in the error message.
* Greatly increased PHPdoc coverage for WP-CLI internals.

Fixes:

* Persists db collation when using `wp db reset`.
* Running `wp search-replace` will no longer clobber other WP installs in the same database.
* Prevents loading a required file twice if both global config and project config files require it.
* When creating a user, the generated password will display again.
* Fix fatal error in `wp scaffold _s`.
* The `--post__in` argument works again for `wp export`.
* Themes and plugins can be listed with their `update_version`.
* When running or deleting cron events, all matching events will be affected (instead of just the first).
* GUIDs are escaped as URLs for `wp export`.
* Thanks to improvements in php-cli-tools, long strings in tables will be wrapped, instead of breaking output. See in action with `wp theme get twentyfourteen`.

You can browse the full list of [resolved issues](https://github.com/wp-cli/wp-cli/issues?q=milestone%3A0.17.0+is%3Aclosed) on Github.

Contributors to this release: [danielbachhuber](https://github.com/danielbachhuber), [dlh01](https://github.com/dlh01), [jeichorn](https://github.com/jeichorn), [johnbillion](https://github.com/johnbillion), [lkwdwrd](https://github.com/lkwdwrd), [mattheu](https://github.com/mattheu), [nschoenholtz](https://github.com/nschoenholtz), [phh](https://github.com/phh), [rodrigoprimo](https://github.com/rodrigoprimo), [santagada](https://github.com/santagada), [scribu](https://github.com/scribu), [szepeviktor](https://github.com/szepeviktor), [tddewey](https://github.com/tddewey), [tollmanz](https://github.com/tollmanz), [trepmal](https://github.com/trepmal), [willmot](https://github.com/willmot).
