---
layout: post
author: danielbachhuber
title: Version 0.18.0 released
---

Hello 2015! Here's your first release for the new year.

### Update WP-CLI using WP-CLI

We've made it even easier to keep WP-CLI up to date. If you're using the Phar file and it's writable, you can call `wp cli update` to install the latest version.


    $ ./wp-cli.0.17.1.phar cli update
    You have version 0.17.1. Would you like to update to 0.18.0? [y/n] y
    Downloading from https://github.com/wp-cli/wp-cli/releases/download/v0.18.0/wp-cli.phar...
    New version works. Proceeding to replace.
    Success: Updated WP-CLI to 0.18.0

Of course, if you've installed WP-CLI via Composer or Git, you should run master to always get the latest and greatest.

### Manage post and user terms

WP-CLI supports managing terms associated with posts and users:

    $ wp post term add 1 post_tag foo
    Success: Added term.
    
    $ wp post term add 1 post_tag bar
    Success: Added term.
    
    $ wp post term list 1 post_tag
    +---------+------+------+----------+
    | term_id | name | slug | taxonomy |
    +---------+------+------+----------+
    | 4       | bar  | bar  | post_tag |
    | 3       | foo  | foo  | post_tag |
    +---------+------+------+----------+
    
    $ wp post term remove 1 post_tag foo bar
    Success: Deleted term.

### Consistent behavor for plugin activation and deactivation

We've cleaned up the behavior for activating and deactivating plugins:

* If a plugin is already active, it's allowed to become network active.
* If a plugin is already network active, it's *not* allowed to become active.
* Network active plugins must be deactivated with the `--network` flag.
* A warning will be thrown when an inactive plugin is attempted to be deactivated.

Previously, the behavior was quite inconsistent — sometimes you'd get errors, sometimes silent success, etc.

### What's coming in 2015

If I may editorialize a bit, I think 2015 could be an interesting year for WP-CLI.

The [WP-API project](http://github.com/wp-api/wp-api) has more overlap than you may think. The task of building a RESTful API for WordPress is also a task of preparing a useful abstraction to interact with WordPress internals. Instead of directly calling `wp_update_post()`, the API uses `WP_JSON_Posts_Controller::update_item()`, which is a consistent interface with `WP_JSON_Terms_Controller::update_item()` and `WP_JSON_Users_Controller::update_item()`.

Similarly, we too have had to invent our own pattern of abstraction for interacting with WordPress internals. It would be nice if we could drop much of our code, and leverage WP-API instead. And, what if `WP_JSON_Controller` was the pattern we adopted for listing, getting, creating, updating, or deleting any WordPress primitive, which means that plugins implementing it would automatically have WP-CLI commands?

Plus, I'd think it would be quiet useful to have feature parity between what I can do locally with WP-CLI, and what I can do against a remote site via WP-API.

### Other changes

Enhancements:

* Migrate users between sites in one go — `wp user import-csv <file>` supports CSV produced by `wp user list --format=csv > <file>`.
* Use `wp user list --network` to list all users in your network.
* All subcommand help docs also include global parameters, to give those global parameters more visibility.
* If `--help` flag is passed, a command will now show the help screen instead of erroring on invalid parameters. Useful for debugging aforementioned errored parameters.
* Similar to `--skip-plugins=<plugin>,<plugin>`, the `--skip-themes` global parameter allows you to skip loading specific themes when using WP-CLI. If you run a hosting company, this can be a useful way to blacklist known problem themes when performing maintenance.
* `wp core language` improvements: Use `wp core language list --fields=language --status=active` to get the active language; install and activate a language with `wp core language install <language> --activate`; active language can't be uninstalled.
* `wp (post|comment|term|user) get <object-id>` supports `--fields` parameter for getting specific fields.
* Use `wp post update <object-id>` to update a post's content from a `<file>`.
* Activate all installed plugins at once with `wp plugin activate --all`.
* `wp plugin list` now indicates version numbers for mu plugins when they have properly formatted plugin headers.
* Added support for specifying any version for `wp plugin update <plugin>... --version=<version>`. Previously, the parameter only supported 'dev'.
* `wp option update <name> <value>` will supply a friendly message when the option is already set to the supplied value.
* Added alias from `wp theme uninstall` to `wp theme delete`, giving greater parity between theme and plugin interfaces.
* Adopted a Debian package build script.

Bug fixes:

* Resolved a nasty file cache collision between `wp core update` and `wp core download`. `WP_CLI\CoreUpgrader` was renaming ZIP files to `.tar.gz`, which `wp core download` would then attempt to use.
* If a file required by `wp-cli.yml` or `--require` is missing, WP-CLI will throw a human-friendly error instead of fataling.
* `wp cli info` runs early to protect from invalid runtime configurations.
* `wp core config` will only define WPLANG for WP < 4.0.
* `/bin/install-wp-tests.sh` fixes: Properly marked executable when scaffolding plugin unit tests; works on older versions of Bash; added support for `WP_CORE_DIR` environment variable.
* `wp comment (approve|unapprove)` will actually change comment status.
* `wp_is_mobile()` is defined, avoiding fatals in some themes and plugins.
* Windows fixes: disabled colors by default; allows deleting plugins that aren't in folders (e.g. Hello Dolly).
* Throws an error when trying to get meta on a missing object, instead of silently failing.
* Throws an error when trying to install multisite with subdomains when domain is `localhost`.
* Doesn't force update check on `wp plugin install` to reduce dependency on WordPress.org.

You can browse the full list of [resolved issues](https://github.com/wp-cli/wp-cli/issues?q=milestone%3A0.18.0+is%3Aclosed) on Github.

Contributors to this release: [viper007bond](https://github.com/viper007bond), [boonebgorges](https://github.com/boonebgorges), [borekb](https://github.com/borekb), [bparbs](https://github.com/bradp), [danielbachhuber](https://github.com/danielbachhuber), [here](https://github.com/here), [miya0001](https://github.com/miya0001), [nyordanov](https://github.com/nyordanov), [oneumyvakin](https://github.com/oneumyvakin), [ozh](https://github.com/ozh), [pippinsplugins](https://github.com/pippinsplugins), [rodrigoprimo](https://github.com/rodrigoprimo), [spacedmonkey](https://github.com/spacedmonkey), [ntwb](https://github.com/ntwb), [lordspace](https://github.com/lordspace), [szepeviktor](https://github.com/szepeviktor), [tiagohillebrandt](https://github.com/tiagohillebrandt), [wturrell](https://github.com/wturrell)
