---
layout: post
author: danielbachhuber
title: Version 0.19.0 released
---

2015 is an exciting time for WP-CLI. WP-API is days away from 2.0-beta1, and brings with it a powerful new interface to WordPress. In the near future, we'll start exploring how WP-CLI can use WP-API internally. If all goes well, WP-CLI could see just one more 0.x.0 release before the big 1.0.0.

### Plugin scaffolding

`wp plugin scaffold` is a great way to get started on your next WordPress plugin. It automates many procedural steps you can easily forget to do, or need to copy and paste out of another plugin. v0.19.0 brings these improvements:

* `bin/install-wp-tests.sh` will use either cURL or wget, depending on which is available. The script is also more fault tolerant.
* Use the `--dir=<path-to-dir>` argument to scaffold your new plugin to an arbitrary directory (e.g. mu-plugins or a theme folder).
* For custom projects, use the `--activate-network` flag to network activate the plugin after creation.
* Generates a Gruntfile with two helpful tasks: `grunt readme` to build a `README.md` from your `readme.txt`, and `grunt i18n` to create a `.pot` file.
* The default `.travis.yml` has increased maximum tested PHP version to 5.5, is more smart about the build matrix it generates, and changes notifications preferences to only email developers on build failures.

### Other changes in v0.19.0

Enhancements:

* `wp option list` lists all options, or searching for specific options based on a pattern. Use `--format=total_bytes` to get the total bytes for the matching options.
* Use `--all-tables` flag for `wp search-replace` to perform replacements against all tables in the database. In 0.17.0, we changed the behavior of `wp search-replace` to only affect tables registered to `$wpdb`. This new flag permits users to opt-in to all tables.
* When scaffolding a child theme, the parent theme's stylesheet is enqueued, instead of being loaded via `@import`.
* Added a `wp core language update` command to update language files.
* Added a `--dashicon` argument to `wp scaffold post-type` which will specify the icon for the post type.
* Added a `--sassify` argument to `wp scaffold _s` to download the SASS version of `_s`.
* MySQL binary commands execute with `--no-auto-rehash` for a substantial performance boost on larger databases.
* On export, taxonomy terms with missing parents are explicitly identified to make them easier to fix.
* When updating an option or post/user/comment meta and the supplied value is the same as the stored value, the success message indicates such.
* Added `--format=ids` to `wp post term list`.
* Added `--skip-delete` flag to `wp media regenerate`. This is helpful on sites where thumbnails might've been linked to within post content. Skipping deletion prevents breaking image references.
* Added `after_invoke` hook for any post-command execution tasks.
* Supports filtering by site value in `wp site list`.
* Added archive/unarchive, activate/deactivate and spam/not-spam subcommands to `wp site`.
* Added a summary table to output of `wp theme update` and `wp plugin update`. This makes it easier to parse the final results when you're updating a number of themes or plugins in one go.
* On multisite, user creation is run through `wpmu_validate_user_signup()` and `wpmu_create_user()`, which perform multisite-specific validation rules.
* The object cache is periodically cleared on import to prevent excess memory usage.
* Nightly builds are accompanied by checksums.

Bug fixes:

* Introduces `\WP_CLI\Utils\get_flag_value()` helper function to fix a systemic problem throughout WP-CLI. [Read through this issue](https://github.com/wp-cli/wp-cli/issues/1696) for the full details.
* Provides a human-friendly error when an invalid class is specified for a command. The prior behavior was to fatal error.
* Correctly sets `sslverify` argument when testing WP-Cron.
* Importer throws a hard error if process to import a file returns `WP_Error`. `create_author_mapping_file()` uses `WP_Error` to report that an author mapping file needs to be updated. However, when importing a directory of WXR files, the prior logic to use `WP_CLI::warning()` means the second file will use the author mapping file of the first, which should've been edited.
* Comment meta values are wrapped in CDATA tags on export.
* `wp core multisite-install` and `wp core multisite-convert` will properly include `define( 'WP_ALLOW_MULTISITE', true );` constant.
* https scheme is honored for the `--url` argument.
* `wp post term list` displays error for an invalid taxonomy.
* `WP_CLI::error()` respects `$exit` argument.
* Provides a human-friendly error when an incorrect version or locale was supplied for `wp core download` The prior behavior was to fatal error.
* `wp cron event schedule` respects the `<next-run>` argument.
* Child themes aren't permitted to be activated without their parent installed.
* Themes are network enabled based on stylesheet value, not template. Previously, it wasn't possible to network-enable a child theme because of this bug.


You can browse the full list of [resolved issues](https://github.com/wp-cli/wp-cli/issues?q=milestone%3A0.19.0+is%3Aclosed) on Github.

Contributors to this release: [2ndkauboy](https://github.com/2ndkauboy), [acusti](https://github.com/acusti), [bobbywalters](https://github.com/bobbywalters), [bmackinney](https://github.com/bmackinney), [danielbachhuber](https://github.com/danielbachhuber), [francescolaffi](https://github.com/francescolaffi), [heiglandreas](https://github.com/heiglandreas), [hirozed](https://github.com/hirozed), [jeichorn](https://github.com/jeichorn), [johnbillion](https://github.com/johnbillion), [joshbetz](https://github.com/joshbetz), [jpry](https://github.com/jpry), [keeth](https://github.com/keeth), [mavin](https://github.com/mavin), [morganestes](https://github.com/morganestes), [mwithheld](https://github.com/mwithheld), [nyordanov](https://github.com/nyordanov), [rodrigoprimo](https://github.com/rodrigoprimo), [sebastiaandegeus](https://github.com/sebastiaandegeus), [szepeviktor](https://github.com/szepeviktor), [wrnx](https://github.com/wrnx), [yivi](https://github.com/yivi)
