---
layout: post
author: danielbachhuber
title: Version 0.21.0 released
---

It's been a pretty crazy week so far, and it's only Wednesday.

As many of you are aware of, I launched a Kickstarter campaign Monday night: [A more RESTful WP-CLI](https://www.kickstarter.com/projects/danielbachhuber/a-more-restful-wp-cli). Incredibly, it was 100% funded in just under 12 hours. Check out the link for more details on what I'll be working on in early 2016.

But, I have an even more **important note** about supported WordPress versions:

* WP-CLI v0.22.0 (the next release) will bump the minimum supported WordPress version from 3.5 to 3.7 ([background](https://github.com/wp-cli/wp-cli/issues/2134)).
* WP-CLI versions prior to 0.20.3 will be incompatible with WordPress 4.4 ([background](http://wp-cli.org/blog/version-0.20.3.html)).

This important note may apply to you in some way -- please take action accordingly.

WP-CLI v0.21.0 represents [109 resolved issues and pull requests](https://github.com/wp-cli/wp-cli/issues?q=milestone%3A0.21.0+is%3Aclosed). Here's what's new.

### Load WordPress with `WP_CLI::get_runner()->load_wordpress();`

For a while now, you've been able to run a WP-CLI command before WordPress loads by adding `@when before_wp_load` to your command docs. Now, you can load WordPress that same command.

See how `wp eval` makes use of `WP_CLI::get_runner()->load_wordpress()`:

    class Eval_Command extends WP_CLI_Command {
        
        /**
         * Execute arbitrary PHP code.
         *
         * <php-code>
         * : The code to execute, as a string.
         *
         * [--skip-wordpress]
         * : Execute code without loading WordPress.
         *
         * @when before_wp_load
         *
         * ## EXAMPLES
         *
         *     wp eval 'echo WP_CONTENT_DIR;'
         */
        public function __invoke( $args, $assoc_args ) {
            if ( null === Utils\get_flag_value( $assoc_args, 'skip-wordpress' ) ) {
                WP_CLI::get_runner()->load_wordpress();
            }
            eval( $args[0] );
        }
    }

Use `wp eval --skip-wordpress <code>` to execute PHP without loading WordPress. Or, use `wp eval-file --skip-wordpress <file>` to, say, execute a quick and dirty script leveraging WP-CLI utilities without needing a WordPress install present.

Similarly, when you specify a `--version=<version>` with `wp core verify-checksums`, WP-CLI will check to ensure core files haven't been modified -- without loading WordPress.

Creating this new feature was almost like replacing the engine on a moving car.

### More verbosity with `--debug`

When you supply the `--debug` flag, you'll get more context into how WP-CLI is executing your command.

Before:

    $ wp option get home --debug
    http://wordpress-test.dev

After:

    $ wp option get home --debug
    Debug: Using default global config: /home/vagrant/.wp-cli/config.yml (0.026s)
    Debug: No project config found (0.027s)
    Debug: Required file from config: /srv/www/wp-rest-cli/wp-rest-cli.php (0.059s)
    Debug: ABSPATH defined: /srv/www/wordpress-test.dev/ (0.06s)
    Debug: Begin WordPress load (0.063s)
    Debug: wp-config.php path: /srv/www/wordpress-test.dev/wp-config.php (0.065s)
    Debug: Set URL: wordpress-test.dev/ (0.066s)
    Debug: Loaded WordPress (0.515s)
    Debug: Running command: option get (0.516s)
    http://wordpress-test.dev

Make your own commands more helpful by including `WP_CLI::debug( $debug_message );` at key checkpoints.

### Other changes in v0.21.0

Enhancements:

* Use `wp core update-db --network` to upgrade databases across an entire network; also improves verbosity for this command by providing the `from` and `to` database versions.
* Adds a `wp comment recount` command for recalcuating a post's comment count.
* Includes `wp taxonomy list`, `wp taxonomy get`, `wp post-type list` and `wp post-type get` for getting details about registered taxonomies and post types.
* Use `--defer-term-counting` with `wp post update` or `wp post delete` to recalculate term count at the end of the operation for increased performance.
* Returns a more useful error message when running `wp scaffold plugin-tests` with an invalid plugin slug.
* In `wp theme list`, indicates a parent theme by setting the `status=parent`. This more clearly distinguishes between a genuinely inactive theme vs. an "inactive" theme being used as a parent theme.
* Displays error message when trying to use `wp rewrite flush --hard` on a multisite install, because WordPress doesn't generate a `.htaccess` file for multisite installs.
* Permits `--path` for `wp core download`, even when WP is detected. This lets a custom WP-CLI command download WP to a subdirectory, when loaded from the scope of an existing WP install.
* Adds `--post_type__not_in` argument to `wp export`, which can now produce an export without, say, `feedbacks`.
* Permits space-delimited IDs for `wp export --post__in`. This makes it easier to pass IDs returned by `wp post list --format=ids`.
* Includes an `.editorconfig` when using `wp scaffold plugin`.
* Newly-generated `install-wp-tests.sh` files support `$WP_VERSION=trunk` or `$WP_VERSION=nightly` for running your plugin tests against WordPress trunk.
* Warns user when `wp-config.php` isn't writable for `wp core multisite-convert`.
* Provides a more helpful error message when an invalid subcommand has a valid parent command.
* Supports using WP-CLI on a WordPress instance backed by APC cache, but only after warning and requiring confirmation.
* Sniffs out the custom vendor path if WP-CLI is a part of a larger Composer project.
* Deprecates `wp post url` in favor of `wp post list --field=url`, but includes a backwards compatability shim for `wp post url`.
* Supports `--autoload=(yes|no)` when using `wp option update` (requires WordPress 4.2).
* Supports multiple comment ids for `wp comment (spam|trash|approve)`.
* Paginates help output on Windows using `more`.
* Provides human-friendly output when rewrite rules successfully flush.

Bug fixes:

* Generic arguments are no longer required for `wp post create` and `wp comment create`, allowing use of those commands without supplying, say, a title.
* Accepts associative args with no right-side data.
* Exhausts all possible options when looking for PHP binary with `wp cli update`. Previously, WP-CLI would try to call `php` directly, which would fail on systems where PHP wasn't exposed as such.
* Accommodates `wp_new_user_notification()`'s deprecated second argument, depending on WordPress version.

You can browse the full list of [resolved issues](https://github.com/wp-cli/wp-cli/issues?q=milestone%3A0.21.0+is%3Aclosed) on Github.

Contributors to this release: [aaemnnosttv](https://github.com/aaemnnosttv), [borekb](https://github.com/borekb), [danielbachhuber](https://github.com/danielbachhuber), [gmcinnes](https://github.com/gmcinnes), [JRGould](https://github.com/JRGould), [johnbillion](https://github.com/johnbillion), [kraftbj](https://github.com/kraftbj), [miya0001](https://github.com/miya0001), [ntwb](https://github.com/ntwb), [rodrigoprimo](https://github.com/rodrigoprimo), [rmccue](https://github.com/rmccue) [szepeviktor](https://github.com/szepeviktor), [torounit](https://github.com/torounit), [voldemortensen](https://github.com/voldemortensen), [ypid](https://github.com/ypid)
