---
layout: post
author: danielbachhuber
title: Version 0.22.0 released
---

Happy 2016! I thought you might enjoy a new WP-CLI release before I dive into the RESTful CLI project.

Use `wp cli update` to install v0.22.0, representing [137 resolved issues and pull requests](https://github.com/wp-cli/wp-cli/issues?q=milestone%3A0.22.0+is%3Aclosed). Here's what's new.

### search-replace for love and profit

Last month, [Pantheon](https://pantheon.io/) generously sponsored 15 hours of my time to address some of the long-standing bugs in the backlog, and make a few substantial enhancements too.

Let's start with the good stuff:

* Performance boost! Instead of running a MYSQL LIKE statement every 1000 rows, WP-CLI now just runs it once [[#2304](https://github.com/wp-cli/wp-cli/pull/2304)]. On a post meta table of ~3.5 million rows where 75,610 rows were affected, this change improved execution time from 734.926s to 225.509s (3.3x faster).
* Use the `--export=<filename>` argument to create a SQL file of your transformed data, instead of making updates to the database [[#2254](https://github.com/wp-cli/wp-cli/pull/2254)]. This is a helpful feature when you want to prepare a database for a new environment without having to import and then run search-replace.
* Wildcards can be used in table names [[#2233](https://github.com/wp-cli/wp-cli/pull/2233)]. search-replace against just meta tables with `wp search-replace <old-string> <new-string> '*meta*'`. Note: the pattern needs to be quoted, as `*` is a special character in Bash.

I also landed a number of search-replace bug fixes and minor enhancements:

* Recurses objects by default when replacing inside of serialized data [[#2222](https://github.com/wp-cli/wp-cli/pull/2222)]. Among other things, this ensures theme mods are transformed as expected. You can disable the behavior with `--no-recurse-objects`. But, if you do disable the behavior, I'd like to hear from you. I think this is an unnecessary option we could remove at a later date.
* Properly escapes quotes used in search or replace strings [[#2230](https://github.com/wp-cli/wp-cli/pull/2230)].
* Lets users know to flush their persistent object cache after a search-replace procedure is performed [[#2236](https://github.com/wp-cli/wp-cli/pull/2236)].
* Bails early when the replacement string is the same as the search string [[#2235](https://github.com/wp-cli/wp-cli/pull/2235)].
* Indicates execution time when running search/replace with `--verbose` [[#2242](https://github.com/wp-cli/wp-cli/pull/2242)].
* Prevents unnecessary calls to `$wpdb->update()` when there are no replacements to be made [[#2245](https://github.com/wp-cli/wp-cli/pull/2245)].
* Drops unnecessary `REGEXP` query when in regex mode [[#2305](https://github.com/wp-cli/wp-cli/pull/2305)].

### Changes to supported versions

WP-CLI's minimum supported WordPress version is now 3.7 [[#2261](https://github.com/wp-cli/wp-cli/pull/2261)].

We also officially support PHP 7 [[#2330](https://github.com/wp-cli/wp-cli/pull/2330)].

### Everything else in v0.22.0

Improvements to `wp scaffold (plugin|plugin-tests)`:

* Makes Travis less noisy by only sending email notifications on the initial build failure for a branch [[#2194](https://github.com/wp-cli/wp-cli/pull/2194)].
* Plugin header follows WordPress' PHPDoc standards [[#2197](https://github.com/wp-cli/wp-cli/pull/2197)].
* Adds `.dist` extension to PHPUnit config file to permit overriding with a local config file [[#2247](https://github.com/wp-cli/wp-cli/pull/2247)]
* Parses `readme.txt` to find WordPress versions to use as Travis tested versions [[#2255](https://github.com/wp-cli/wp-cli/pull/2255)].
* Includes a default `.gitignore` [[#2297](https://github.com/wp-cli/wp-cli/pull/2297)].

New flags for existing commands:

* `wp core update --minor` to only perform minor updates [[#2256](https://github.com/wp-cli/wp-cli/pull/2256)].
* `wp (post|comment|user) meta delete <id> --all` to delete all meta values on a given object [[#2265](https://github.com/wp-cli/wp-cli/pull/2265)].
* `wp core update-db --dry-run` to see whether a database needs an upgrade [[#2293](https://github.com/wp-cli/wp-cli/pull/2293)].
* `wp media regenerate --only-missing` for faster performance on sites with lots of images where only a small number are missing sizes [[#2292](https://github.com/wp-cli/wp-cli/pull/2292)].
* `wp cron event run --all` to execute all registered cron events [[#2323](https://github.com/wp-cli/wp-cli/pull/2323)].
* `wp site empty --uploads` to empty a site and delete its uploads directory too [[#2339](https://github.com/wp-cli/wp-cli/pull/2339)].
* `wp core install --skip-email` to install without email notifications [[#2345](https://github.com/wp-cli/wp-cli/pull/2345)].
* `wp transient (get|set|delete) --network` to manage site transients [[#2351](https://github.com/wp-cli/wp-cli/pull/2351)].

Framework enhancements:

* Introduces `wp_version_compare()` when comparing WordPress versions [[#2237](https://github.com/wp-cli/wp-cli/pull/2237)]. SVN and Git tags include `-src` in `$wp_version`, which
`version_compare()` doesn't like.
* Defers to the `$PAGER` environment variable when set [[#2264](https://github.com/wp-cli/wp-cli/pull/2264)].
* Introduces a `composer.lock` file to the project, to fix dependencies to specific hashes [[#2280](https://github.com/wp-cli/wp-cli/pull/2280)].
* Magically globalizes any new variables defined in wp-config.php, as they're expected to be global [[#2318](https://github.com/wp-cli/wp-cli/pull/2318)].
* If a `--require=<file>` is missing, specifies the context of where the missing file is referenced for easier debugging [[#2336](https://github.com/wp-cli/wp-cli/pull/2336)].
* Use `mustangostang/spyc` instead of bundling our own copy [[#2350](https://github.com/wp-cli/wp-cli/pull/2350)]. The `Spyc` class is still available in the global namespace.
* Introduces `WP_CLI\Utils\get_temp_dir()` for safer temp directories [[#2353](https://github.com/wp-cli/wp-cli/pull/2353)].

Improvements to other commands:

* Includes `not_found` label when scaffolding a custom taxonomy [[#2196](https://github.com/wp-cli/wp-cli/pull/2196)].
* Permits installing remote plugin files without `.zip` in filename [[#2193](https://github.com/wp-cli/wp-cli/pull/2193)].
* Warns when adding a user as a super admin when the user is already a super admin [[#2202](https://github.com/wp-cli/wp-cli/pull/2202)].
* Uses `WP_CLI::log()` instead of `WP_CLI::line()` in `wp import`, so `--quiet` flag is respected [[#2234](https://github.com/wp-cli/wp-cli/pull/2234)].
* Adds support to `wp db tables` for wildcard tables (e.g. `*meta*`), `--all-tables-with-prefix`, and `--format=csv` [[#2250](https://github.com/wp-cli/wp-cli/pull/2250)].
* Improves error message when installing a plugin or theme and the resource isn't found [[#2253](https://github.com/wp-cli/wp-cli/pull/2253),[#2267](https://github.com/wp-cli/wp-cli/pull/2267)].
* Supports custom `wp export` filename formats with `--filename_format=<format>` [[#2230](https://github.com/wp-cli/wp-cli/pull/2300)]
* Assumes db errors during `wp install` to be installation failures, and reports accordingly [[#2337](https://github.com/wp-cli/wp-cli/pull/2337)].
* Exposes plugin header details at runtime for `wp scaffold plugin` [[#2338](https://github.com/wp-cli/wp-cli/pull/2338)].
* Includes `ci/behat-tags.php` in `wp scaffold package-tests` [[#2342](https://github.com/wp-cli/wp-cli/pull/2342)].

Bug fixes across the board:

* Lets `help` run early when WP is detected, but not installed (e.g. `wp core config --help`) [[#2190](https://github.com/wp-cli/wp-cli/pull/2190)]. Bug was introduced in v0.20.0.
* When scaffolding a child theme, creates a safe version of the parent theme slug for the child enqueue function [[#2203](https://github.com/wp-cli/wp-cli/pull/2203)]. Previously, if the parent slug included dashes, an invalid enqueue function would be scaffolded.
* Suppresses error notices when looking for `wp-config.php` and PHP's `open_basedir` is in effect [[#2211](https://github.com/wp-cli/wp-cli/pull/2211)].
* Fixes error notice in `WP_CLI\Loggers\Quiet` [[#2210](https://github.com/wp-cli/wp-cli/pull/2210)].
* Fixes `all_items` label in custom post type scaffolding [[#2213](https://github.com/wp-cli/wp-cli/pull/2213)].
* Ensures `install-package-tests.sh` actually downloads the nightly WP-CLI Phar build, and not a redirect [[#2214](https://github.com/wp-cli/wp-cli/pull/2214)].
* Sets the `upload_space_check_disabled` to `1` when installing multisite [[#2238](https://github.com/wp-cli/wp-cli/pull/2238)]. This mirrors core's behavior on new installs.
* Provides a more helpful message when image regeneration fails [[#2239](https://github.com/wp-cli/wp-cli/pull/2239)].
* Properly updates menu sub-item parent when parent is deleted [[#2262](https://github.com/wp-cli/wp-cli/pull/2262)].
* Stops prefixing rewrite rules with `index.php` when using `wp rewrite structure` [[#2279](https://github.com/wp-cli/wp-cli/pull/2279)].
* Fixes typo in `wp transient set` synopsis [[#2282](https://github.com/wp-cli/wp-cli/pull/2282)].
* Restores `wp core verify-checksums` for non-US English locales [[#2287](https://github.com/wp-cli/wp-cli/pull/2287)]. Bug was introduced in v0.21.0.
* Switches to the readline library, when available, for better support of arrow keys using `--prompt` [[#2325](https://github.com/wp-cli/wp-cli/pull/2325)].
* `WP_CLI\Formatter` properly checks for null values on objects [[#2322](https://github.com/wp-cli/wp-cli/pull/2322)].
* In `wp media import`, uses host instead of scheme to determine whether a file is remote or local, for Windows compatibility [[#2324](https://github.com/wp-cli/wp-cli/pull/2324)].
* Ensures updating a plugin with an invalid `--version=<version>` specified doesn't delete the plugin [[#2346](https://github.com/wp-cli/wp-cli/pull/2346)].

Contributors to this release: [2ndkauboy](https://github.com/2ndkauboy), [coreyworrell](https://github.com/coreyworrell), [danielbachhuber](https://github.com/danielbachhuber), [davidleach](https://github.com/davidleach), [duncanjbrown](https://github.com/duncanjbrown), [ernilambar](https://github.com/ernilambar), [fjarrett](https://github.com/fjarrett), [gilbitron](https://github.com/gilbitron), [greg-1-anderson](https://github.com/greg-1-anderson), [iandunn](https://github.com/iandunn), [jjeaton](https://github.com/jjeaton), [modelm](https://github.com/modelm), [rodrigoprimo](https://github.com/rodrigoprimo), [ryanshoover](https://github.com/ryanshoover), [stevector](https://github.com/stevector), [szepeviktor](https://github.com/szepeviktor), [tristanpenman](https://github.com/tristanpenman), [x1024](https://github.com/x1024)

You can browse the full list of [resolved issues](https://github.com/wp-cli/wp-cli/issues?q=milestone%3A0.22.0+is%3Aclosed) on Github.
