---
layout: post
author: danielbachhuber
title: The future of WP-CLI
---

As you might be aware, WP-CLI is an indispensable tool for many individuals and companies. We very much appreciate our community of users (although we have no idea how many of you there actually are), and want to ensure our relationship is strong for the years to come.

Just over a month ago, I [started a Github issue](https://github.com/wp-cli/wp-cli/issues/2743) with this question:

> how do I reduce WP-CLI's bus factor, and more generally lay a foundation for WP-CLI's long-term organizational stability?

Although things seem to be going reasonably well now, I want to make sure we're taking steps towards ensuring the long-term continuity of the project. Today, Andreas (WP-CLI's founder) and I sat down for breakfast to discuss our options and how we want to proceed.

Based on our conversation, we think the most important task is to reduce WP-CLI's bus factor and onboard one or more additional maintainers to focus on a few non-code roles:

* Documentation - Help ensure WP-CLI's documentation is world-class.
* Marketing / community management - Help spread the word about WP-CLI.
* Support - Help WP-CLI users where they're asking questions, let it be Github, WordPress.org, Stack Exchange, or elsewhere.

Contributions in these areas will always be welcome. Maintainership is a longer-term commitment to the project, focused on ongoing improvements to the specific area. WP-CLI expects its maintainers to commit a few hours per week to the project.

At this time, we don't have plans to establish a legal WP-CLI organization. We've decided the operational complexities exceed the benefits. While many companies and individuals want to donate to WP-CLI, introducing money always has the possibility of causing more harm than good. Instead, we'll use Kickstarter to fund larger endeavors (e.g. a logo and website redesign) on an as-needed basis.

If you would like to become a maintainer of WP-CLI in a non-code role, please email [info@wp-cli.org](mailto:info@wp-cli.org). Expect to participate in a trial period of 2-3 months.

We have a Mailchimp mailing list now too. [Sign up](http://wp-cli.us13.list-manage.com/subscribe?u=0615e4d18f213891fc000adfd&id=8c61d7641e) for email notifications of new versions and occasional announcements about the project.

Thanks,

Daniel Bachhuber, maintainer  
Andreas Creten, founder
