---
layout: post
author: danielbachhuber
title: Version 0.24.0 released
---

As I [mentioned in my WordCamp Europe talk](https://runcommand.io/2016/06/26/my-condolences-youre-now-the-maintainer-of-a-popular-open-source-project/):

> Just like WordPress has plugins, the future of WP-CLI is packages of commands. For this future, I’m trying to proactively solve the problems WordPress has with plugins:
>
> * Where WordPress plugins are considered second-class to what’s included in core, I’d like WP-CLI packages to be considered first-class citizens amongst the commands in WP-CLI.
> * All too often, WordPress plugins have just one author. I’d like for each WP-CLI package to have two or three active maintainers.

In this model, WP-CLI becomes the common interface, and supporting application layer, to a rich ecosystem of features. Doing so opens more frontiers for innovation, which leads to a greater selection of ideas to choose from. And because more people are involved in authoring packages, WP-CLI benefits from a larger contributor pool.

With this model, my focus shifts towards designing a world-class experience for WP-CLI package authorship. Read through the [commands cookbook](http://wp-cli.org/docs/commands-cookbook/) for a thorough introduction to creating a WP-CLI command. Check out `wp scaffold package` [[repo](https://github.com/wp-cli/scaffold-package-command)] for the easiest way to generate the boilerplate for your new WP-CLI package. Weigh in with your thoughts on [how we should evolve the WP-CLI package index](https://github.com/wp-cli/wp-cli/issues/3197). And [follow @runcommand](https://twitter.com/runcommand) as I explore commercializing WP-CLI products and services — I hope that [runcommand](https://runcommand.io) is just the first of several WP-CLI-based businesses.

One last ask: if you care about the WP-CLI release cycle, or dependencies and backwards compatibility, please [let me know how often you think WP-CLI should be released](https://github.com/wp-cli/wp-cli/issues/3198).

Let's get on with the show. Use `wp cli update` to install v0.24.0, representing [449 resolved issues and pull requests](https://github.com/wp-cli/wp-cli/issues?q=milestone%3A0.24.0+is%3Aclosed). Here's what's new.

### Forked `wp-settings.php` no more

Every application has a bootstrap file which loads all of the requisite utilities needed to serve a request. In WordPress, this is called `wp-settings.php`.

Since v0.8.0 [[#261](https://github.com/wp-cli/wp-cli/pull/261)], WP-CLI has used a forked version of this bootstrap file, called `wp-settings-cli.php`, to give it more control over the load process, providing features like `--skip-plugins`. But, because WordPress can require new files from `wp-settings.php`, maintaining a forked version has the unfortunate side effect of WP-CLI [regularly breaking when a new version of WordPress is released](http://wp-cli.org/blog/versions-0.21.1-and-0.20.4.html).

Thanks to coordinated changes in the WordPress project, WP-CLI v0.24.0 returns to loading `wp-settings.php` for WordPress 4.6 and higher [[#2278](https://github.com/wp-cli/wp-cli/issues/2278)]. Doing so should make WP-CLI more future proof against new versions of WordPress.

### More documentation in more languages

Thanks to tireless efforts by a solid group of contributors, WP-CLI now has more documentation in more languages.

* Dozens of commands have improved examples for reference.
* We have a new [CONTRIBUTING.md](https://github.com/wp-cli/wp-cli/blob/master/CONTRIBUTING.md), which also has a [page on the website](http://wp-cli.org/docs/contributing/).
* Our new [README.md](https://github.com/wp-cli/wp-cli/blob/master/README.md) powers the [WP-CLI homepage](http://wp-cli.org/), and is available in [Japanese](http://wp-cli.org/ja/), [Français](http://wp-cli.org/fr/), [Português (Brasil)](http://wp-cli.org/br/), [Türkçe](http://wp-cli.org/tr/), [Deutsch](http://wp-cli.org/de/), [नेपाली](http://wp-cli.org/ne/), and [ελληνικά](http://wp-cli.org/gr/).

Want to get involved with WP-CLI's documentation? Check out the [Github issues labeled "scope:documentation"](https://github.com/wp-cli/wp-cli/issues?q=is%3Aopen+sort%3Aupdated-desc+label%3Ascope%3Adocumentation).

### Effortlessly use WP-CLI against any WordPress install

WP-CLI aliases are shortcuts you register in your `wp-cli.yml` or `config.yml` to effortlessly run commands against any WordPress install.

For instance, if I'm working locally on the runcommand theme, have registered a new rewrite rule, and need to flush rewrites inside my Vagrant-based virtual machine, I can run:

    $ wp @dev rewrite flush
    Success: Rewrite rules flushed.

Then, once the code goes to production, I can run:

    $ wp @prod rewrite flush
    Success: Rewrite rules flushed.

Look ma! No more SSH'ing into machines, changing directories, and generally spending a full minute to get to a given WordPress install.

Additionally, alias groups let you register groups of aliases. If I want to run a command against both runcommand WordPress instances, I can use `@both`:

    $ wp @both core check-update
    Success: WordPress is at the latest version.
    Success: WordPress is at the latest version.

Aliases can be registered in your project's `wp-cli.yml` file, or your user's global `~/.wp-cli/config.yml` file:

    @prod:
      ssh: runcommand@runcommand.io~/webapps/production
    @dev:
      ssh: vagrant@192.168.50.10/srv/www/runcommand.dev
    @both:
      - @prod
      - @dev

### But wait, what's the 'ssh' in there?

WP-CLI now natively supports a `--ssh=<host>` global parameter for running a command against a remote WordPress install. Many thanks to XWP and their community for paving the way with [WP-CLI SSH](https://github.com/xwp/wp-cli-ssh).

Under the hood, WP-CLI proxies commands to the `ssh` executable, which then passes them to WP-CLI installed on the remote machine. Your syntax for `-ssh=<host>` can be any of the following:

* Just the host (e.g. `wp --ssh=runcommand.io`), which means the user will be inferred from your current system user, and the path will be the SSH user's home directory.
* The user and the host (e.g. `wp --ssh=runcommand@runcommand.io`).
* The user, the host, and the path to the WordPress install (e.g. `wp --ssh=runcommand@runcommand.io~/webapps/production`). The path comes immediately after the TLD of the host.

Or, if you use a `~/.ssh/config`, `<host>` can be any host alias stored in the SSH config (e.g. `wp --ssh=rc` for me).

Note you do need a copy of WP-CLI on the remote server, accessible as `wp`. Futhermore, `--ssh=<host>` won't load your `.bash_profile` if you have a shell alias defined, or are extending the `$PATH` environment variable. If this affects you, [here's a more thorough explanation](https://runcommand.io/to/wp-ssh-custom-path/) of how you can make `wp` accessible.

Relevant pull requests for aliases and SSH support include: [#2755](https://github.com/wp-cli/wp-cli/pull/2755), [#2974](https://github.com/wp-cli/wp-cli/pull/2974), [#3012](https://github.com/wp-cli/wp-cli/pull/3012), [#3013](https://github.com/wp-cli/wp-cli/pull/3013), [#3014](https://github.com/wp-cli/wp-cli/pull/3014), [#3016](https://github.com/wp-cli/wp-cli/pull/3016), [#3026](https://github.com/wp-cli/wp-cli/pull/3026), [#3040](https://github.com/wp-cli/wp-cli/pull/3040), [#3070](https://github.com/wp-cli/wp-cli/pull/3070), [#3093](https://github.com/wp-cli/wp-cli/pull/3093), [#3100](https://github.com/wp-cli/wp-cli/pull/3100), [#3117](https://github.com/wp-cli/wp-cli/pull/3117), [#3134](https://github.com/wp-cli/wp-cli/pull/3134), [#3135](https://github.com/wp-cli/wp-cli/pull/3135), [#3145](https://github.com/wp-cli/wp-cli/pull/3145), [#3161](https://github.com/wp-cli/wp-cli/pull/3161), [#3180](https://github.com/wp-cli/wp-cli/pull/3180).

### Everything else in 0.24.0

Command improvements:

* Adds a newline when using the `wp shell` interactive prompt [[#2601](https://github.com/wp-cli/wp-cli/pull/2601), [#2659](https://github.com/wp-cli/wp-cli/pull/2659)].
* Improves formatting of scaffolded plugins [[#2588](https://github.com/wp-cli/wp-cli/pull/2588), [#2598](https://github.com/wp-cli/wp-cli/pull/2598)].
* Introduces `--format=ids` to `wp (*) generate` commands for easier chaining [[2622](https://github.com/wp-cli/wp-cli/pull/2622)].
* Adds `term recount` command for trigger a recount of taxonomy terms assigned to posts [[#2625](https://github.com/wp-cli/wp-cli/pull/2625), [#2628](https://github.com/wp-cli/wp-cli/pull/2628)].
* Normalizes plugin / theme version numbers and header formatting when scaffolding [[#2644](https://github.com/wp-cli/wp-cli/pull/2644)].
* Introduces `--due-now` to run all cron events due or overdue [[#2658](https://github.com/wp-cli/wp-cli/pull/2658)].
* Permits `wp cron (event|schedule) list` and `wp option list` to output a single field [[#2657](https://github.com/wp-cli/wp-cli/pull/2657), [#3033](https://github.com/wp-cli/wp-cli/pull/3033)].
* Adds field filtering in cron event list command [[#2674](https://github.com/wp-cli/wp-cli/pull/2674)].
* Includes a `.distignore` file when scaffolding a new plugin, to define files and folders excluded from distributions [[#2697](https://github.com/wp-cli/wp-cli/pull/2697), [#2756](https://github.com/wp-cli/wp-cli/pull/2756), [#3042](https://github.com/wp-cli/wp-cli/pull/3042), [#3088](https://github.com/wp-cli/wp-cli/pull/3088)].
* Displays a summary success message when using `--dry-run` with `wp search-replace` [[#2740](https://github.com/wp-cli/wp-cli/pull/2740)].
* Scaffolds plugin based on supported WordPress version [[#2751](https://github.com/wp-cli/wp-cli/pull/2751)].
* Applies extended insert format to search-replace SQL export, for a substantial performance boost [[#2745](https://github.com/wp-cli/wp-cli/pull/2745)].
* Warns with `wp core verify-checksums` when extra files exist in wp-admin or wp-includes [[#2638](https://github.com/wp-cli/wp-cli/pull/2638)].
* Supports `--format=<format>` argument for `wp cap list`, `wp user list-caps`, and `wp super-admin list` [[#2851](https://github.com/wp-cli/wp-cli/pull/2851), [#2961](https://github.com/wp-cli/wp-cli/pull/2961), and [#2949](https://github.com/wp-cli/wp-cli/pull/2949)].
* Accepts multiple term IDs with `wp term url` [[#2865](https://github.com/wp-cli/wp-cli/pull/2865)].
* Supports PHP 5.5 Memcache extension when checking cache type [[#2945](https://github.com/wp-cli/wp-cli/pull/2945)].
* Uses `WP_CLI::warning()` when a theme is already active, to make behavior more consistent with plugin activation [[#3015](https://github.com/wp-cli/wp-cli/pull/3015)].
* Adds `--porcelain` flag to `wp db export` [[#3032](https://github.com/wp-cli/wp-cli/pull/3032)].
* Allow the author field to be selected in `wp theme list --fields=<field>` [[#3043](https://github.com/wp-cli/wp-cli/pull/3043)].
* Introduces `wp widget reset <sidebar>`, for removing all widgets from a sidebar and placing them in the inactive sidebar [[#3077](https://github.com/wp-cli/wp-cli/pull/3077)].
* Supports 'trunk' and 'nightly' version arguments for `wp core download` [[#3127](https://github.com/wp-cli/wp-cli/pull/3127)].
* Adds verbosity to `wp role reset` [[#3132](https://github.com/wp-cli/wp-cli/pull/3132), [#3141](https://github.com/wp-cli/wp-cli/pull/3141)].
* Adds `--include-columns=<columns>` argument to `wp search-replace` [[#3142](https://github.com/wp-cli/wp-cli/pull/3142)].
* Adds `--ci=<provider>` argument for `wp plugin test scaffold`, which supports 'travis', 'circle', or 'gitlab' [[#3144](https://github.com/wp-cli/wp-cli/pull/3144), [#3163](https://github.com/wp-cli/wp-cli/pull/3163)].

Framework enhancements:

* Uses `is_callable()` in `WP_CLI::add_command()`, instead of custom logic [[#2595](https://github.com/wp-cli/wp-cli/pull/2595)].
* Introduces `CompositeCommand->remove_subcommand()`, and modifies the bootstrap process to always register core commands [[#2629](https://github.com/wp-cli/wp-cli/pull/2629)].
* Runs `before_invoke` and `after_invoke` callbacks on subcommands, such that you can hook into immediately before and after subcommand execution [[#2647](https://github.com/wp-cli/wp-cli/pull/2647), [#2686](https://github.com/wp-cli/wp-cli/pull/2686)].
* Introduces `--debug=<group>` to limit debug output to a particular group of debug calls [[#2648](https://github.com/wp-cli/wp-cli/pull/2648)].
* Interacts with the Package Index over SSL [[#2720](https://github.com/wp-cli/wp-cli/pull/2720)].
* Supports CSV with spaces when using `--fields=<fields>` [[#2750](https://github.com/wp-cli/wp-cli/pull/2750)].
* Disables WP cron when `ALTERNATE_WP_CRON` is defined [[#3118](https://github.com/wp-cli/wp-cli/pull/3118)].
* Supports positional arguments defined in `wp-cli.yml` [[#3120](https://github.com/wp-cli/wp-cli/pull/3120)].
* Introduces `WP_CLI_STRICT_ARGS_MODE` for dealing with arg ambiguity [[#3128](https://github.com/wp-cli/wp-cli/pull/3128)].
* Registers `--http=<url>` global parameter for use with RESTful WP-CLI [[#3130](https://github.com/wp-cli/wp-cli/pull/3130)].
* Introduces `WP_CLI::add_wp_hook()`, for adding actions and filters when you don't yet have access to actions and filters [[#3195](https://github.com/wp-cli/wp-cli/pull/3195)].
* Increases minimum supported PHP version to 5.3.29 [[#2672](https://github.com/wp-cli/wp-cli/pull/2672)].

Bug fixes across the board:

* Mitigates a DateTime fatal when instantiating the Composer object [[#2607](https://github.com/wp-cli/wp-cli/pull/2607)].
* Squashes `wp export` notice about `skip_comments` [[#2620](https://github.com/wp-cli/wp-cli/pull/2620)].
* Avoids regex to fix greedy parsing of parameter arguments [[#2587](https://github.com/wp-cli/wp-cli/pull/2587), [#2717](https://github.com/wp-cli/wp-cli/pull/2717)].
* Ensures `default` and `options` are used when supplied as arg args [[#2741](https://github.com/wp-cli/wp-cli/pull/2741)].
* Considers image sizes missing when using `wp media regenerate` and `sizes` doesn't have registered sizes [[#2645](https://github.com/wp-cli/wp-cli/pull/2645)].
* Catches `WP_Error` from `translations_api()` [[#2671](https://github.com/wp-cli/wp-cli/pull/2671), [#3179](https://github.com/wp-cli/wp-cli/pull/3179)].
* Doesn't erroneously try to (de)activate plugins with `--all` flag [[#2692](https://github.com/wp-cli/wp-cli/pull/2692)].
* Defines `DOING_CRON` before WordPress is loaded when running `wp cron event run`  [[#2691](https://github.com/wp-cli/wp-cli/pull/2691)].
* Only attempts to use `add_user_to_blog()` on multisite when importing users from CSV [[#2690](https://github.com/wp-cli/wp-cli/pull/2690)].
* Fixes listing user meta associated with a given username [[#2700](https://github.com/wp-cli/wp-cli/pull/2700)].
* Differentiates output when moving comments to trash from output when deleting comments [[#2701](https://github.com/wp-cli/wp-cli/pull/2701)].
* Prevents runaway memory usage from `wp export` by clearing object cache after each file [[#2716](https://github.com/wp-cli/wp-cli/pull/2716)].
* Ignores ambigious empty plugin and theme slugs when installing [[#2715](https://github.com/wp-cli/wp-cli/pull/2715)].
* Takes all digits when running commands that use the comment id [[#2714](https://github.com/wp-cli/wp-cli/pull/2714), [#2901](https://github.com/wp-cli/wp-cli/pull/2901)].
* Only displays packages directory path when it exists [[#2773](https://github.com/wp-cli/wp-cli/pull/2773)].
* Bails early in theme commands if theme is broken or has error [[#2798](https://github.com/wp-cli/wp-cli/pull/2798)].
* Displays error if theme directory exists but is erred; permits force install [[#2821](https://github.com/wp-cli/wp-cli/pull/2821)].
* Fixes PHP notice when installing a child theme, and running `wp theme status` [[#2976](https://github.com/wp-cli/wp-cli/pull/2976), [#3047](https://github.com/wp-cli/wp-cli/pull/3047)].
* Ensures YAML formatter handles objects and `--fields=<fields>` arg [[#3060](https://github.com/wp-cli/wp-cli/pull/3060)].
* Fixes exception in `wp menu list` if `--format=ids` [[#3075](https://github.com/wp-cli/wp-cli/pull/3075)].
* Populates recently active plugins list when deactivating a plugin [[#3068](https://github.com/wp-cli/wp-cli/pull/3068)].
* Respects `wp-cli.yml` default values when applying argument defaults [[#3111](https://github.com/wp-cli/wp-cli/pull/3111)].
* Calls `wp_slash()` on data passed to post, comment, term, and user commands [[#3156](https://github.com/wp-cli/wp-cli/pull/3156), [#3157](https://github.com/wp-cli/wp-cli/pull/3157), [#3158](https://github.com/wp-cli/wp-cli/pull/3158), [#3159](https://github.com/wp-cli/wp-cli/pull/3159), [#3167](https://github.com/wp-cli/wp-cli/pull/3167), [#3173](https://github.com/wp-cli/wp-cli/pull/3173)].
* Appropriately lists duplicated cron events [[#3175](https://github.com/wp-cli/wp-cli/pull/3175)].

Contributors to this release: [andyexeter](https://github.com/andyexeter), [bordoni](https://github.com/bordoni), [danielbachhuber](https://github.com/danielbachhuber), [diggy](https://github.com/diggy), [enrico-sorcinelli](https://github.com/enrico-sorcinelli), [ernilambar](https://github.com/ernilambar), [geo4orce](https://github.com/geo4orce), [gedex](https://github.com/gedex), [gilbitron](https://github.com/gilbitron), [hideokamoto](https://github.com/hideokamoto), [apertureless](https://github.com/apertureless), [JRGould](https://github.com/JRGould), [johnbillion](https://github.com/johnbillion), [kkoppenhaver](https://github.com/kkoppenhaver), [kouratoras](https://github.com/kouratoras), [markjaquith](https://github.com/markjaquith), [miya0001](https://github.com/miya0001), [mustafauysal](https://github.com/mustafauysal), [NateWr](https://github.com/NateWr), [Nikschavan](https://github.com/Nikschavan), [ocean90](https://github.com/ocean90), [petenelson](https://github.com/petenelson), [phh](https://github.com/phh), [rachelbaker](https://github.com/rachelbaker), [PatelUtkarsh](https://github.com/PatelUtkarsh), [PeterDaveHello](https://github.com/PeterDaveHello), [robhenley](https://github.com/robhenley) [rodrigoprimo](https://github.com/rodrigoprimo), [roelveldhuizen](https://github.com/roelveldhuizen), [ShinichiNishikawa](https://github.com/ShinichiNishikawa), [shulard](https://github.com/shulard), [stephenharris](https://github.com/stephenharris), [stevenkword](https://github.com/stevenkword), [swissspidy](https://github.com/swissspidy), [taianunes](https://github.com/taianunes), [villevuor](https://github.com/villevuor), [voldemortensen](https://github.com/voldemortensen), [wesm87](https://github.com/wesm87), [8bitodyssey](https://github.com/8bitodyssey)

You can browse the full list of [resolved issues](https://github.com/wp-cli/wp-cli/issues?q=milestone%3A0.24.0+is%3Aclosed) on Github.

Back to work!
