---
layout: post
author: danielbachhuber
title: Version 0.25.0 released
---

Happy release day!

Today, I'm excited to bring you WP-CLI v0.25.0. Check out the [newly published roadmap](/docs/roadmap/) for details on upcoming releases and product focus (hint: there's a future where WP-CLI no longer supports PHP 5.3).

Let's dive in.

### Compatibility with WordPress 4.7

WordPress 4.7 introduces a new `WP_Hook` implementation for registering and executing actions and filters. Because WP-CLI has its own `WP_CLI::add_wp_hook()` that was erroneously accessing the `$wp_filter` global even when the `add_filter()` function was available, WP-CLI could fatal in certain circumstances. WP-CLI now appropriately calls `add_filter()` when it's available.

**Importantly, due to the nature of these changes, WP-CLI versions prior to 0.25.0 will be incompatible with WordPress 4.7.**

Inspect the change in [this pull request](https://github.com/wp-cli/wp-cli/pull/3384).

### New packages in the Package Index

The WP-CLI community has been quite active in creating new tools for you to use (and contribute back to):

* [aaemnnosttv/wp-cli-login-command](https://github.com/aaemnnosttv/wp-cli-login-command) - Log in to WordPress with secure passwordless magic links.
* [alessandrotesoro/wp-cli-helpscout-docs-parser](https://github.com/alessandrotesoro/wp-cli-helpscout-docs-parser) - Extract helpscout docs articles and categories to build an offline documentation.
* [alessandrotesoro/wp-usergen-cli](https://github.com/alessandrotesoro/wp-usergen-cli) - Generate random users for testing purposes.
* [anhskohbo/wp-cli-themecheck](https://github.com/anhskohbo/wp-cli-themecheck) - Run Themecheck in WP-CLI.
* [BeAPI/wp-cli-light-db-export](https://github.com/BeAPI/wp-cli-light-db-export) - Allows you to export big databases with all the tables but not all the data.
* [binarygary/db-checkpoint](https://github.com/binarygary/db-checkpoint) - Treat your DB like a save point in a video game.
* [brightoak/wp-cli-envoyer](https://github.com/brightoak/wp-cli-envoyer) - Invoke an Envoyer deployment via WP-CLI.
* [getshifter/wp-cli-shifter](https://github.com/getshifter/wp-cli-shifter) - Enables you to import/export your WordPress site for the Shifter.
* [eriktorsner/wp-checksum](https://github.com/eriktorsner/wp-checksum) - Verify checksums for themes and plugins.
* [iandunn/wp-cli-plugin-active-on-sites](https://github.com/iandunn/wp-cli-plugin-active-on-sites) - List all sites in a multisite network that have activated a given plugin.
* [markri/wp-sec](https://github.com/markri/wp-sec) - Checks for WordPress CVE security issues at wpvulndb.com.
* [mattgrshaw/wp-installer](https://github.com/mattgrshaw/wp-installer) - Simple commands to install and uninstall WordPress.
* [pressbooks/pb-cli](https://github.com/pressbooks/pb-cli) - A suite of wp-cli commands for Pressbooks.
* [runcommand/assign-featured-images](https://github.com/runcommand/assign-featured-images) - Assign featured images to posts that support thumbnails.
* [runcommand/manifest](https://github.com/runcommand/manifest) - Produces an overview of WordPress' configuration for a high-level understanding of what's going on inside of WordPress.
* [rxnlabs/wp-composer](https://github.com/rxnlabs/wp-composer) - Manage your WordPress site dependencies using the power of Composer.
* [trendwerk/faker](https://github.com/trendwerk/faker) - Fake post data with WP-CLI.
* [trepmal/blog-extractor](https://github.com/trepmal/blog-extractor) - Extract a single blog from multisite.
* [trepmal/wp-revisions-cli](https://github.com/trepmal/wp-revisions-cli) - Manage revisions.
* [welaika/wp-cli-db2utf8](https://github.com/welaika/wp-cli-db2utf8) - Downgrade db encoding of a new WP installation to UTF8.

Install any one of these with `wp package install <package-name>` (where `<package-name>` is typically the `<user>/<repo>`). When you do, go say thanks to the author!

### More ways to install WP-CLI packages

Although we'd love to see your package listed in the Package Index, we realize there are reasons you might not be able to do so. `wp package install` now supports installing an arbitrary Git URL [[#3482](https://github.com/wp-cli/wp-cli/pull/3482)], `.zip` file [[#3485](https://github.com/wp-cli/wp-cli/pull/3485)], or directory path [[#3484](https://github.com/wp-cli/wp-cli/pull/3484)] as a package.

    $ wp package install git@github.com:runcommand/doctor.git
    $ wp package install https://github.com/runcommand/doctor.zip
    $ wp package install doctor

(doctor is the [second premium WP-CLI command from runcommand](https://runcommand.io/wp/doctor/))

It's worth noting Composer's behavior is slightly different for each package type:

* Git URLs are treated as VCS repositories, and cloned to `~/.wp-cli/packages/vendor`.
* ZIP archives (remote and local) are extracted to `~/.wp-cli/packages/local`, and added as path repositories.
* Local directory paths are added as path repositories, which means Composer creates a symlink to the existing directory path. If the directory you've provided is removed, then the installation will break.

### Everything else in 0.25.0

New commands:

* `wp db check` - Runs `mysqlcheck` with the default `--check` option [[#3332](https://github.com/wp-cli/wp-cli/pull/3332)].
* `wp site option *` - CRUD commands for managing WordPress site options [[#3386](https://github.com/wp-cli/wp-cli/pull/3386)].
* `wp user session *` - CRUD commands for managing user sessions [[#3307](https://github.com/wp-cli/wp-cli/pull/3307)].

Command improvements:

* `wp cli update`:
   * Introduces `--stable` to install or reinstall the latest stable version [[#3430](https://github.com/wp-cli/wp-cli/pull/3430)].
* `wp core config`:
   * Adds comments to generated `wp-config.php` to better match the one provided by WordPress core [[#3312](https://github.com/wp-cli/wp-cli/pull/3312)].
* `wp core download`:
   * Preserves case for `--version` argument to properly handle release candidates [[#3283](https://github.com/wp-cli/wp-cli/pull/3283)].
   * Ensures `wp core download --version=latest` produces correctly-versioned cache key [[#3467](https://github.com/wp-cli/wp-cli/pull/3467)].
* `wp core language update`:
   * Fixes strict standard error about variable reference [[#3380](https://github.com/wp-cli/wp-cli/pull/3380)].
   * Permits updating language packs even when `en_US` is set as locale [[#3397](https://github.com/wp-cli/wp-cli/pull/3397)].
* `wp core multisite-(install|convert)`:
   * Warns when multisite constants can't be inserted into `wp-config.php`, instead of erroneously inserting at the end [[#3272](https://github.com/wp-cli/wp-cli/pull/3272)].
   * Includes adequate vertical spacing around inserted constants [[#3267](https://github.com/wp-cli/wp-cli/pull/3267)].
* `wp core update-db`:
   * Ensures `wp core update-db --network --dry-run` is actually dry [[#3347](https://github.com/wp-cli/wp-cli/pull/3347)].
* `wp core version`:
   * Displays default core language in `wp core version --extra` [[#3221](https://github.com/wp-cli/wp-cli/pull/3221)].
* `wp import`:
   * Indicates current file in WXR import progress indicator to communicate the total count is of the current file, not all files [[#3270](https://github.com/wp-cli/wp-cli/pull/3270)].
* `wp media regenerate`:
   * Adds a simple progress indicator [[#3407](https://github.com/wp-cli/wp-cli/pull/3407)].
* `wp option list`:
   * Adds `--no-transients` flag to ignore transients [[#3452](https://github.com/wp-cli/wp-cli/pull/3452)].
   * Adds `--exclude=<exclude>` argument to list options excluding a specific pattern [[#3455](https://github.com/wp-cli/wp-cli/pull/3455)].
* `wp package install`
   * Displays package dependency details when installing a package with a dependency [[#3418](https://github.com/wp-cli/wp-cli/pull/3418), [#3425](https://github.com/wp-cli/wp-cli/pull/3425)].
* `wp package uninstall`
   * Removes a package's dependencies when the package is removed [[#3343](https://github.com/wp-cli/wp-cli/pull/3343)].
   * Properly assigns `$composer_backup` when uninstalling [[#3399](https://github.com/wp-cli/wp-cli/pull/3399)].
* `wp plugin install`:
   * Removes branch names from directories created for Github-based ZIPs [[#3314](https://github.com/wp-cli/wp-cli/pull/3314), [#3451](https://github.com/wp-cli/wp-cli/pull/3451)].
* `wp scaffold plugin-tests`:
   * Uses PHP version specific to Trusty on CircleCI [[#3359](https://github.com/wp-cli/wp-cli/pull/3359)].
   * Uses correct default user for MySQL on CircleCI [[#3457](https://github.com/wp-cli/wp-cli/pull/3457)].
   * Uses the latest version of PHPUnit on Travis, depending on PHP version [[#3463](https://github.com/wp-cli/wp-cli/pull/3463)].
   * Adds WordPress Coding Standards to newly-scaffolded plugins [[#3472](https://github.com/wp-cli/wp-cli/pull/3472)].
* `wp search-replace`:
   * Ensures tables are quoted to support all permitted characters [[#3318](https://github.com/wp-cli/wp-cli/pull/3318)].
   * Prevents error notice when `export_insert_size` isn't defined [[#3357](https://github.com/wp-cli/wp-cli/pull/3357)].
   * Fails back to PHP if SQL triggers an error for some reason [[#3387](https://github.com/wp-cli/wp-cli/pull/3387)].
* `wp server`:
   * Supports passing a custom `.ini` file to configure the server [[#3330](https://github.com/wp-cli/wp-cli/pull/3330)].
* `wp site create`:
   * Use `get_blog_details()` for the site URL when creating a new site to ensure the correct URL is displayed [[#3416](https://github.com/wp-cli/wp-cli/pull/3416)].
* `wp site empty`:
   * Ensures the entire uploads directory is empty [[#3400](https://github.com/wp-cli/wp-cli/pull/3400)].
* `wp theme install`:
   * Correctly installs parent theme when installing a child theme [[#3301](https://github.com/wp-cli/wp-cli/pull/3301)].
* `wp transient`:
   * Consolidates `wp transient delete-all` and `wp transient delete-expired` to flags of `wp transient delete` [[#3389](https://github.com/wp-cli/wp-cli/pull/3389)].
* `wp user create`:
   * Prevents email notifications when users are created because email notifications should only be sent when `--send-email` is provided [[#3331](https://github.com/wp-cli/wp-cli/pull/3331)].

Framework enhancements:

* Updates Composer-based dependencies to latest [[#3257](https://github.com/wp-cli/wp-cli/pull/3257), [#3429](https://github.com/wp-cli/wp-cli/pull/3429), [#3460](https://github.com/wp-cli/wp-cli/pull/3460), [#3468](https://github.com/wp-cli/wp-cli/pull/3468)].
* Properly handles registering an instantiated object as a command [[#3269](https://github.com/wp-cli/wp-cli/pull/3269)].
* Splits the `ProcessRun` class out to its own file [[#3377](https://github.com/wp-cli/wp-cli/pull/3377), [#3422](https://github.com/wp-cli/wp-cli/pull/3422)].
* Permits running test suite with `WP_VERSION` env variable [[#3383](https://github.com/wp-cli/wp-cli/pull/3383), [#3392](https://github.com/wp-cli/wp-cli/pull/3392)].
* Prevents error notice when using `Utils\get_named_sem_ver()` with WP versions [[#3404](https://github.com/wp-cli/wp-cli/pull/3404)].
* Fixes fatal error for failed early database connection by handling `dead_db()` error on `nocache_headers` filter [[#3440](https://github.com/wp-cli/wp-cli/pull/3440)].
* Assigns a default `$_SERVER['SERVER_NAME']` to prevent uncaught exception when `wp_mail()` is used [[#3449](https://github.com/wp-cli/wp-cli/pull/3449)].
* Ignores `url:` in `wp-cli.yml` when alias is used, because aliases completely override user, url, path, ssh, and http [[#3450](https://github.com/wp-cli/wp-cli/pull/3450)].
* Warns when `WP_CLI::launch()` ends up with `return_code=-1`, which could be caused by a custom compiled version of PHP that uses the `--enable-sigchild` option [[#3458](https://github.com/wp-cli/wp-cli/pull/3458)].
* Provides more verbosity in `wp_die()` handler to give the end user more detail when a database connection fails [[#3459](https://github.com/wp-cli/wp-cli/pull/3459)].
* Supports passing arguments to `WP_CLI::do_hook()` [[#3470](https://github.com/wp-cli/wp-cli/pull/3470)].
* Logs the current alias when executing an alias group [[#3471](https://github.com/wp-cli/wp-cli/pull/3471)].
* Only checks `options` for a positional argument when a value is present [[#3481](https://github.com/wp-cli/wp-cli/pull/3481)].
* Variety of bash completion improvements [[#3490](https://github.com/wp-cli/wp-cli/pull/3490), [#3491](https://github.com/wp-cli/wp-cli/pull/3491), [#3492](https://github.com/wp-cli/wp-cli/pull/3492)].

Bug fixes across the board:

* Defines all requisite dependencies for PHP 7 on Debian-based systems [[#3208](https://github.com/wp-cli/wp-cli/pull/3208)].
* Ensures `site --site_id= -> site --network_id=` backwards compat shim only affects `wp site create` [[#3227](https://github.com/wp-cli/wp-cli/pull/3227)].
* Catches exceptions thrown by `RecursiveDirectoryIterator` when verifying core checksums [[#3266](https://github.com/wp-cli/wp-cli/pull/3266)].
* Passes slashed data in meta commands [[#3274](https://github.com/wp-cli/wp-cli/pull/3274)].
* Ensures appropriate WP-CLI package index URL is used in the `composer.json` [[#3276](https://github.com/wp-cli/wp-cli/pull/3276)].
* Corrects reference of `WP_CLI` to use global namespace in `WP_CLI\Utils\get_temp_dir()` [[#3369](https://github.com/wp-cli/wp-cli/pull/3369)].

Contributors to this release (pull requests, documentation, and package authors): [2ndkauboy](https://github.com/2ndkauboy), [aaemnnosttv](https://github.com/aaemnnosttv), [alessandrotesoro](https://github.com/alessandrotesoro), [anhskohbo](https://github.com/anhskohbo), [balbuf](https://github.com/balbuf), [BeAPI](https://github.com/BeAPI), [binarygary](https://github.com/binarygary), [bradp](https://github.com/bradp), [brightoak](https://github.com/brightoak), [danielbachhuber](https://github.com/danielbachhuber), [danilomaccioni](https://github.com/danilomaccioni), [diggy](https://github.com/diggy), [getshifter](https://github.com/getshifter), [eriktorsner](https://github.com/eriktorsner), [ernilambar](https://github.com/ernilambar), [fisele](https://github.com/fisele), [grappler](https://github.com/grappler), [guillaumemolter](https://github.com/guillaumemolter), [iandunn](https://github.com/iandunn), [johnbillion](https://github.com/johnbillion), [jorgeatorres](https://github.com/jorgeatorres), [kouratoras](https://github.com/kouratoras), [markri](https://github.com/markri), [mattgrshaw](https://github.com/mattgrshaw), [miya0001](https://github.com/miya0001), [mustafauysal](https://github.com/mustafauysal), [nyordanov](https://github.com/nyordanov), [ocean90](https://github.com/ocean90), [petenelson](https://github.com/petenelson), [polevaultweb](https://github.com/polevaultweb), [pressbooks](https://github.com/pressbooks), [rahulsprajapati](https://github.com/rahulsprajapati), [runcommand](https://github.com/runcommand), [rxnlabs](https://github.com/rxnlabs), [shulard](https://github.com/shulard), [swissspidy](https://github.com/swissspidy), [szepeviktor](https://github.com/szepeviktor), [taianunes](https://github.com/taianunes), [tnorthcutt](https://github.com/tnorthcutt), [trendwerk](https://github.com/trendwerk), [trepmal](https://github.com/trepmal), [veganista](https://github.com/veganista), [welaika](https://github.com/welaika)

You can browse the full list of [resolved issues](https://github.com/wp-cli/wp-cli/issues?q=milestone%3A0.25.0+is%3Aclosed) on Github.
