---
layout: post
author: danielbachhuber
title: Version 1.0.0 released
---

Woohoo!

Over the course of 5+ years, hundreds of contributors have worked to bring you WP-CLI v1.0.0, which I'm proud to announce today.

This release represents a level of maturity few open source projects achieve. It also marks a moment of transition. The WP-CLI project will shift its focus to the WP-CLI package ecosystem, where it will enable innovation by building and encouraging new features as standalone packages. We hope this approach will promote faster iteration and more creativity, and more sustainably distribute the maintenance burden. As these community packages find success, we'll bring their learnings back into WP-CLI, alongside bug fixes and minor enhancements.

Now that the issue backlog is [down to zero](https://twitter.com/danielbachhuber/status/802951083354009600), I'm personally looking forward to getting more ideas cooking for [runcommand](https://runcommand.io/), my own WP-CLI innovation studio.

Headed to Philly this week? I'll be at Post Status Publish and WCUS (although only until mid-afternoon Friday). Say hello - I'm [@danielbachhuber](https://twitter.com/danielbachhuber) on Twitter.

On with the show...

### Introducing `WP_CLI::runcommand()`

`WP_CLI::runcommand()` ([doc](/docs/internal-api/wp-cli-runcommand/)) is the new best way to run WP-CLI commands from within your WP-CLI command. It's as though `WP_CLI::run_command()` and `WP_CLI::launch_self()` grew up, married, and had the perfect child.

With `WP_CLI::runcommand()`, you can:

* Launch a new child process (default), or reuse the existing process.
* Optionally prevent the process from exiting on error.
* Return STDOUT generated by the command, or all command execution details (STDOUT, STDERR, return_code) as an object.
* Optionally parse captured STDOUT as JSON.

Relevant pull requests include: [#3605](https://github.com/wp-cli/wp-cli/pull/3605), [#3619](https://github.com/wp-cli/wp-cli/pull/3619), [#3621](https://github.com/wp-cli/wp-cli/pull/3621).

### Breaking change: Uses return code 1 when batch operation partially fails

Some commands support performing the same operation against multiple resources (e.g. updating two or more plugins with `wp plugin update akismet hello`). Previously, if one of the operations failed (e.g. a plugin update failed to be downloaded), WP-CLI would display a warning, continue on, and exit with return code 0. Beginning in v1.0.0, WP-CLI uses return code 1 when one or more operations fails.

See [this issue](https://github.com/wp-cli/wp-cli/issues/3577) for more background and rationale.

Affected commands include:

* `wp media (regenerate|import)`
* `wp menu delete`
* `wp menu item delete`
* `wp plugin (install|activate|update|toggle|deactivate|uninstall|delete)`
* `wp super-admin add`
* `wp theme (install|update)`
* `wp term delete`
* `wp widget (delete|deactivate|reset)`

Use `WP_CLI\Utils\report_batch_operation_results()` ([doc](/docs/internal-api/wp-cli-utils-report-batch-operation-results/)) in your custom WP-CLI commands to more easily support this behavior.

Relevant pull requests include: [#3584](https://github.com/wp-cli/wp-cli/pull/3584), [#3583](https://github.com/wp-cli/wp-cli/pull/3583), [#3582](https://github.com/wp-cli/wp-cli/pull/3582), [#3585](https://github.com/wp-cli/wp-cli/pull/3585), [#3586](https://github.com/wp-cli/wp-cli/pull/3586), [#3588](https://github.com/wp-cli/wp-cli/pull/3588).

### Everything else in 1.0.0

New commands:

* `wp package update` - Update all installed WP-CLI packages to their latest version.
* `wp scaffold theme-tests` - Scaffold PHPUnit tests for themes.

Command improvements:

* `wp cache type`:
   * Supports WP LCache as a cache type [[#3504](https://github.com/wp-cli/wp-cli/pull/3504)].
* `wp cli aliases`:
   * Adds `alias` to subcommand for easier access [[#3512](https://github.com/wp-cli/wp-cli/pull/3512)].
* `wp cli update`:
   * Verifies release hash when updating [[#3515](https://github.com/wp-cli/wp-cli/pull/3515)].
   * No longer requires `--allow--root` flag when running as root [[#3576](https://github.com/wp-cli/wp-cli/pull/3576)].
* `wp core config`:
   * Ensures WordPress Coding Standards are applied to the generated wp-config [[#3496](https://github.com/wp-cli/wp-cli/pull/3496)].
* `wp core (install|multisite-install)`
   * Defaults to a randomly generated password for `--admin_password=<password>`, which is now optional [[#3535](https://github.com/wp-cli/wp-cli/pull/3535), [#3573](https://github.com/wp-cli/wp-cli/pull/3573)].
* `wp core language (install|update)`:
   * Caches language pack downloads [[#3595](https://github.com/wp-cli/wp-cli/pull/3595)].
* `wp core update`:
   * Uses global namespace for `WP_Error` in `CoreUpgrader` class [[#3593](https://github.com/wp-cli/wp-cli/pull/3593)].
* `wp core update-db`:
   * Sets the `WP_INSTALLING` constant for the update process [[#3503](https://github.com/wp-cli/wp-cli/pull/3503)].
* `wp package install`:
   * Uses supplied version in package composer.json, instead of "dev-master" [[#3519](https://github.com/wp-cli/wp-cli/pull/3519)].
   * Adds WP-CLI version to package manager's `composer.json`, to gracefully handle WP-CLI version constraints [[#3603](https://github.com/wp-cli/wp-cli/pull/3603)].
* `wp package list`:
   * Indicates when a package has an update available [[#3611](https://github.com/wp-cli/wp-cli/pull/3611), [#3612](https://github.com/wp-cli/wp-cli/pull/3612)].
* `wp post delete`:
   * Correctly indicates revisions are deleted immediately in success message [[#3524](https://github.com/wp-cli/wp-cli/pull/3524)].
* `wp scaffold plugin`:
   * Ignores distribution archive files in `.gitignore` and `.distignore` [[#3520](https://github.com/wp-cli/wp-cli/pull/3520)].
   * Ignores `circle.yml`, `.gitlab-ci.yml` and `behat.yml` in `.distignore` [[#3599](https://github.com/wp-cli/wp-cli/pull/3599)].
* `wp scaffold plugin-tests`:
   * Checks out the data directory in `install-wp-tests.sh` to prevent notices in WP 4.7 [[#3571](https://github.com/wp-cli/wp-cli/pull/3571)].

Framework enhancements:

* Updates Composer-based dependencies to latest [[#3498](https://github.com/wp-cli/wp-cli/pull/3498), [#3525](https://github.com/wp-cli/wp-cli/pull/3525)].
* Introduces `--prompt=<assoc>` to prompt for specific associative args, which lets users avoid exposing secure data in bash history [[#3531](https://github.com/wp-cli/wp-cli/pull/3531)].
* Adds support for the version of PHP that comes with Cygwin [[#3591](https://github.com/wp-cli/wp-cli/pull/3591)].

Contributors to this release (pull requests, documentation, and package authors): [abea](https://github.com/abea), [anttiviljami](https://github.com/anttiviljami), [cobyan](https://github.com/cobyan), [danielbachhuber](https://github.com/danielbachhuber), [diggy](https://github.com/diggy), [ernilambar](https://github.com/ernilambar), [franz-josef-kaiser](https://github.com/franz-josef-kaiser), [greatislander](https://github.com/greatislander), [itspriddle](https://github.com/itspriddle), [miya0001](https://github.com/miya0001), [mmcev106](https://github.com/mmcev106), [mopquill](https://github.com/mopquill), [ocean90](https://github.com/ocean90), [pj-dave](https://github.com/pj-dave), [pkarjala](https://github.com/pkarjala), [richardbuff](https://github.com/richardbuff), [sommarnatt](https://github.com/sommarnatt), [szepeviktor](https://github.com/szepeviktor), [torounit](https://github.com/torounit)

You can browse the full list of [resolved issues](https://github.com/wp-cli/wp-cli/issues?q=milestone%3A1.0.0+is%3Aclosed) on Github.
