const countryData = [
  {
    phoneCode: '1',
    flag: '\ud83c\uddfa\ud83c\uddf8',
    countryCode: 'US',
    countryName: 'United States'
  },
  {
    phoneCode: '93',
    flag: '\ud83c\udde6\ud83c\uddeb',
    countryCode: 'AF',
    countryName: 'Afghanistan'
  },
  {
    phoneCode: '355',
    flag: '\ud83c\udde6\ud83c\uddf1',
    countryCode: 'AL',
    countryName: 'Albania'
  },
  {
    phoneCode: '213',
    flag: '\ud83c\udde9\ud83c\uddff',
    countryCode: 'DZ',
    countryName: 'Algeria'
  },
  {
    phoneCode: '1684',
    flag: '\ud83c\udde6\ud83c\uddf8',
    countryCode: 'AS',
    countryName: 'American Samoa'
  },
  {
    phoneCode: '376',
    flag: '\ud83c\udde6\ud83c\udde9',
    countryCode: 'AD',
    countryName: 'Andorra'
  },
  {
    phoneCode: '244',
    flag: '\ud83c\udde6\ud83c\uddf4',
    countryCode: 'AO',
    countryName: 'Angola'
  },
  {
    phoneCode: '1264',
    flag: '\ud83c\udde6\ud83c\uddee',
    countryCode: 'AI',
    countryName: 'Anguilla'
  },
  {
    phoneCode: '1268',
    flag: '\ud83c\udde6\ud83c\uddec',
    countryCode: 'AG',
    countryName: 'Antigua and Barbuda'
  },
  {
    phoneCode: '54',
    flag: '\ud83c\udde6\ud83c\uddf7',
    countryCode: 'AR',
    countryName: 'Argentina'
  },
  {
    phoneCode: '374',
    flag: '\ud83c\udde6\ud83c\uddf2',
    countryCode: 'AM',
    countryName: 'Armenia'
  },
  {
    phoneCode: '297',
    flag: '\ud83c\udde6\ud83c\uddfc',
    countryCode: 'AW',
    countryName: 'Aruba'
  },
  {
    phoneCode: '61',
    flag: '\ud83c\udde6\ud83c\uddfa',
    countryCode: 'AU',
    countryName: 'Australia'
  },
  {
    phoneCode: '43',
    flag: '\ud83c\udde6\ud83c\uddf9',
    countryCode: 'AT',
    countryName: 'Austria'
  },
  {
    phoneCode: '994',
    flag: '\ud83c\udde6\ud83c\uddff',
    countryCode: 'AZ',
    countryName: 'Azerbaijan'
  },
  {
    phoneCode: '1242',
    flag: '\ud83c\udde7\ud83c\uddf8',
    countryCode: 'BS',
    countryName: 'Bahamas'
  },
  {
    phoneCode: '973',
    flag: '\ud83c\udde7\ud83c\udded',
    countryCode: 'BH',
    countryName: 'Bahrain'
  },
  {
    phoneCode: '880',
    flag: '\ud83c\udde7\ud83c\udde9',
    countryCode: 'BD',
    countryName: 'Bangladesh'
  },
  {
    phoneCode: '1246',
    flag: '\ud83c\udde7\ud83c\udde7',
    countryCode: 'BB',
    countryName: 'Barbados'
  },
  {
    phoneCode: '375',
    flag: '\ud83c\udde7\ud83c\uddfe',
    countryCode: 'BY',
    countryName: 'Belarus'
  },
  {
    phoneCode: '32',
    flag: '\ud83c\udde7\ud83c\uddea',
    countryCode: 'BE',
    countryName: 'Belgium'
  },
  {
    phoneCode: '501',
    flag: '\ud83c\udde7\ud83c\uddff',
    countryCode: 'BZ',
    countryName: 'Belize'
  },
  {
    phoneCode: '229',
    flag: '\ud83c\udde7\ud83c\uddef',
    countryCode: 'BJ',
    countryName: 'Benin'
  },
  {
    phoneCode: '1441',
    flag: '\ud83c\udde7\ud83c\uddf2',
    countryCode: 'BM',
    countryName: 'Bermuda'
  },
  {
    phoneCode: '975',
    flag: '\ud83c\udde7\ud83c\uddf9',
    countryCode: 'BT',
    countryName: 'Bhutan'
  },
  {
    phoneCode: '591',
    flag: '\ud83c\udde7\ud83c\uddf4',
    countryCode: 'BO',
    countryName: 'Bolivia'
  },
  {
    phoneCode: '387',
    flag: '\ud83c\udde7\ud83c\udde6',
    countryCode: 'BA',
    countryName: 'Bosnia and Herzegovina'
  },
  {
    phoneCode: '267',
    flag: '\ud83c\udde7\ud83c\uddfc',
    countryCode: 'BW',
    countryName: 'Botswana'
  },
  {
    phoneCode: '47',
    flag: '\ud83c\udde7\ud83c\uddfb',
    countryCode: 'BV',
    countryName: 'Bouvet Island'
  },
  {
    phoneCode: '55',
    flag: '\ud83c\udde7\ud83c\uddf7',
    countryCode: 'BR',
    countryName: 'Brazil'
  },
  {
    phoneCode: '246',
    flag: '\ud83c\uddee\ud83c\uddf4',
    countryCode: 'IO',
    countryName: 'British Indian Ocean Territory'
  },
  {
    phoneCode: '673',
    flag: '\ud83c\udde7\ud83c\uddf3',
    countryCode: 'BN',
    countryName: 'Brunei Darussalam'
  },
  {
    phoneCode: '359',
    flag: '\ud83c\udde7\ud83c\uddec',
    countryCode: 'BG',
    countryName: 'Bulgaria'
  },
  {
    phoneCode: '226',
    flag: '\ud83c\udde7\ud83c\uddeb',
    countryCode: 'BF',
    countryName: 'Burkina Faso'
  },
  {
    phoneCode: '257',
    flag: '\ud83c\udde7\ud83c\uddee',
    countryCode: 'BI',
    countryName: 'Burundi'
  },
  {
    phoneCode: '855',
    flag: '\ud83c\uddf0\ud83c\udded',
    countryCode: 'KH',
    countryName: 'Cambodia'
  },
  {
    phoneCode: '237',
    flag: '\ud83c\udde8\ud83c\uddf2',
    countryCode: 'CM',
    countryName: 'Cameroon'
  },
  {
    phoneCode: '1',
    flag: '\ud83c\udde8\ud83c\udde6',
    countryCode: 'CA',
    countryName: 'Canada'
  },
  {
    phoneCode: '238',
    flag: '\ud83c\udde8\ud83c\uddfb',
    countryCode: 'CV',
    countryName: 'Cape Verde'
  },
  {
    phoneCode: '345',
    flag: '\ud83c\uddf0\ud83c\uddfe',
    countryCode: 'KY',
    countryName: 'Cayman Islands'
  },
  {
    phoneCode: '236',
    flag: '\ud83c\udde8\ud83c\uddeb',
    countryCode: 'CF',
    countryName: 'Central African Republic'
  },
  {
    phoneCode: '235',
    flag: '\ud83c\uddf9\ud83c\udde9',
    countryCode: 'TD',
    countryName: 'Chad'
  },
  {
    phoneCode: '56',
    flag: '\ud83c\udde8\ud83c\uddf1',
    countryCode: 'CL',
    countryName: 'Chile'
  },
  {
    phoneCode: '86',
    flag: '\ud83c\udde8\ud83c\uddf3',
    countryCode: 'CN',
    countryName: 'China'
  },
  {
    phoneCode: '61',
    flag: '\ud83c\udde8\ud83c\uddfd',
    countryCode: 'CX',
    countryName: 'Christmas Island'
  },
  {
    phoneCode: '61',
    flag: '\ud83c\udde8\ud83c\udde8',
    countryCode: 'CC',
    countryName: 'Cocos (Keeling) Islands'
  },
  {
    phoneCode: '57',
    flag: '\ud83c\udde8\ud83c\uddf4',
    countryCode: 'CO',
    countryName: 'Colombia'
  },
  {
    phoneCode: '269',
    flag: '\ud83c\uddf0\ud83c\uddf2',
    countryCode: 'KM',
    countryName: 'Comoros'
  },
  {
    phoneCode: '242',
    flag: '\ud83c\udde8\ud83c\uddec',
    countryCode: 'CG',
    countryName: 'Congo'
  },
  {
    phoneCode: '243',
    flag: '\ud83c\udde8\ud83c\udde9',
    countryCode: 'CD',
    countryName: 'Congo, The Democratic Republic of the Congo'
  },
  {
    phoneCode: '682',
    flag: '\ud83c\udde8\ud83c\uddf0',
    countryCode: 'CK',
    countryName: 'Cook Islands'
  },
  {
    phoneCode: '506',
    flag: '\ud83c\udde8\ud83c\uddf7',
    countryCode: 'CR',
    countryName: 'Costa Rica'
  },
  {
    phoneCode: '225',
    flag: '\ud83c\udde8\ud83c\uddee',
    countryCode: 'CI',
    countryName: "Cote d'Ivoire"
  },
  {
    phoneCode: '385',
    flag: '\ud83c\udded\ud83c\uddf7',
    countryCode: 'HR',
    countryName: 'Croatia'
  },
  {
    phoneCode: '53',
    flag: '\ud83c\udde8\ud83c\uddfa',
    countryCode: 'CU',
    countryName: 'Cuba'
  },
  {
    phoneCode: '357',
    flag: '\ud83c\udde8\ud83c\uddfe',
    countryCode: 'CY',
    countryName: 'Cyprus'
  },
  {
    phoneCode: '420',
    flag: '\ud83c\udde8\ud83c\uddff',
    countryCode: 'CZ',
    countryName: 'Czech Republic'
  },
  {
    phoneCode: '45',
    flag: '\ud83c\udde9\ud83c\uddf0',
    countryCode: 'DK',
    countryName: 'Denmark'
  },
  {
    phoneCode: '253',
    flag: '\ud83c\udde9\ud83c\uddef',
    countryCode: 'DJ',
    countryName: 'Djibouti'
  },
  {
    phoneCode: '1767',
    flag: '\ud83c\udde9\ud83c\uddf2',
    countryCode: 'DM',
    countryName: 'Dominica'
  },
  {
    phoneCode: '1849',
    flag: '\ud83c\udde9\ud83c\uddf4',
    countryCode: 'DO',
    countryName: 'Dominican Republic'
  },
  {
    phoneCode: '593',
    flag: '\ud83c\uddea\ud83c\udde8',
    countryCode: 'EC',
    countryName: 'Ecuador'
  },
  {
    phoneCode: '20',
    flag: '\ud83c\uddea\ud83c\uddec',
    countryCode: 'EG',
    countryName: 'Egypt'
  },
  {
    phoneCode: '503',
    flag: '\ud83c\uddf8\ud83c\uddfb',
    countryCode: 'SV',
    countryName: 'El Salvador'
  },
  {
    phoneCode: '240',
    flag: '\ud83c\uddec\ud83c\uddf6',
    countryCode: 'GQ',
    countryName: 'Equatorial Guinea'
  },
  {
    phoneCode: '291',
    flag: '\ud83c\uddea\ud83c\uddf7',
    countryCode: 'ER',
    countryName: 'Eritrea'
  },
  {
    phoneCode: '372',
    flag: '\ud83c\uddea\ud83c\uddea',
    countryCode: 'EE',
    countryName: 'Estonia'
  },
  {
    phoneCode: '251',
    flag: '\ud83c\uddea\ud83c\uddf9',
    countryCode: 'ET',
    countryName: 'Ethiopia'
  },
  {
    phoneCode: '500',
    flag: '\ud83c\uddeb\ud83c\uddf0',
    countryCode: 'FK',
    countryName: 'Falkland Islands (Malvinas)'
  },
  {
    phoneCode: '298',
    flag: '\ud83c\uddeb\ud83c\uddf4',
    countryCode: 'FO',
    countryName: 'Faroe Islands'
  },
  {
    phoneCode: '679',
    flag: '\ud83c\uddeb\ud83c\uddef',
    countryCode: 'FJ',
    countryName: 'Fiji'
  },
  {
    phoneCode: '358',
    flag: '\ud83c\uddeb\ud83c\uddee',
    countryCode: 'FI',
    countryName: 'Finland'
  },
  {
    phoneCode: '33',
    flag: '\ud83c\uddeb\ud83c\uddf7',
    countryCode: 'FR',
    countryName: 'France'
  },
  {
    phoneCode: '594',
    flag: '\ud83c\uddec\ud83c\uddeb',
    countryCode: 'GF',
    countryName: 'French Guiana'
  },
  {
    phoneCode: '689',
    flag: '\ud83c\uddf5\ud83c\uddeb',
    countryCode: 'PF',
    countryName: 'French Polynesia'
  },
  {
    phoneCode: '262',
    flag: '\ud83c\uddf9\ud83c\uddeb',
    countryCode: 'TF',
    countryName: 'French Southern Territories'
  },
  {
    phoneCode: '241',
    flag: '\ud83c\uddec\ud83c\udde6',
    countryCode: 'GA',
    countryName: 'Gabon'
  },
  {
    phoneCode: '220',
    flag: '\ud83c\uddec\ud83c\uddf2',
    countryCode: 'GM',
    countryName: 'Gambia'
  },
  {
    phoneCode: '995',
    flag: '\ud83c\uddec\ud83c\uddea',
    countryCode: 'GE',
    countryName: 'Georgia'
  },
  {
    phoneCode: '49',
    flag: '\ud83c\udde9\ud83c\uddea',
    countryCode: 'DE',
    countryName: 'Germany'
  },
  {
    phoneCode: '233',
    flag: '\ud83c\uddec\ud83c\udded',
    countryCode: 'GH',
    countryName: 'Ghana'
  },
  {
    phoneCode: '350',
    flag: '\ud83c\uddec\ud83c\uddee',
    countryCode: 'GI',
    countryName: 'Gibraltar'
  },
  {
    phoneCode: '30',
    flag: '\ud83c\uddec\ud83c\uddf7',
    countryCode: 'GR',
    countryName: 'Greece'
  },
  {
    phoneCode: '299',
    flag: '\ud83c\uddec\ud83c\uddf1',
    countryCode: 'GL',
    countryName: 'Greenland'
  },
  {
    phoneCode: '1473',
    flag: '\ud83c\uddec\ud83c\udde9',
    countryCode: 'GD',
    countryName: 'Grenada'
  },
  {
    phoneCode: '590',
    flag: '\ud83c\uddec\ud83c\uddf5',
    countryCode: 'GP',
    countryName: 'Guadeloupe'
  },
  {
    phoneCode: '1671',
    flag: '\ud83c\uddec\ud83c\uddfa',
    countryCode: 'GU',
    countryName: 'Guam'
  },
  {
    phoneCode: '502',
    flag: '\ud83c\uddec\ud83c\uddf9',
    countryCode: 'GT',
    countryName: 'Guatemala'
  },
  {
    phoneCode: '44',
    flag: '\ud83c\uddec\ud83c\uddec',
    countryCode: 'GG',
    countryName: 'Guernsey'
  },
  {
    phoneCode: '224',
    flag: '\ud83c\uddec\ud83c\uddf3',
    countryCode: 'GN',
    countryName: 'Guinea'
  },
  {
    phoneCode: '245',
    flag: '\ud83c\uddec\ud83c\uddfc',
    countryCode: 'GW',
    countryName: 'Guinea-Bissau'
  },
  {
    phoneCode: '592',
    flag: '\ud83c\uddec\ud83c\uddfe',
    countryCode: 'GY',
    countryName: 'Guyana'
  },
  {
    phoneCode: '509',
    flag: '\ud83c\udded\ud83c\uddf9',
    countryCode: 'HT',
    countryName: 'Haiti'
  },
  {
    phoneCode: '672',
    flag: '\ud83c\udded\ud83c\uddf2',
    countryCode: 'HM',
    countryName: 'Heard Island and Mcdonald Islands'
  },
  {
    phoneCode: '379',
    flag: '\ud83c\uddfb\ud83c\udde6',
    countryCode: 'VA',
    countryName: 'Holy See (Vatican City State)'
  },
  {
    phoneCode: '504',
    flag: '\ud83c\udded\ud83c\uddf3',
    countryCode: 'HN',
    countryName: 'Honduras'
  },
  {
    phoneCode: '852',
    flag: '\ud83c\udded\ud83c\uddf0',
    countryCode: 'HK',
    countryName: 'Hong Kong'
  },
  {
    phoneCode: '36',
    flag: '\ud83c\udded\ud83c\uddfa',
    countryCode: 'HU',
    countryName: 'Hungary'
  },
  {
    phoneCode: '354',
    flag: '\ud83c\uddee\ud83c\uddf8',
    countryCode: 'IS',
    countryName: 'Iceland'
  },
  {
    phoneCode: '91',
    flag: '\ud83c\uddee\ud83c\uddf3',
    countryCode: 'IN',
    countryName: 'India'
  },
  {
    phoneCode: '62',
    flag: '\ud83c\uddee\ud83c\udde9',
    countryCode: 'ID',
    countryName: 'Indonesia'
  },
  {
    phoneCode: '98',
    flag: '\ud83c\uddee\ud83c\uddf7',
    countryCode: 'IR',
    countryName: 'Iran'
  },
  {
    phoneCode: '964',
    flag: '\ud83c\uddee\ud83c\uddf6',
    countryCode: 'IQ',
    countryName: 'Iraq'
  },
  {
    phoneCode: '353',
    flag: '\ud83c\uddee\ud83c\uddea',
    countryCode: 'IE',
    countryName: 'Ireland'
  },
  {
    phoneCode: '44',
    flag: '\ud83c\uddee\ud83c\uddf2',
    countryCode: 'IM',
    countryName: 'Isle of Man'
  },
  {
    phoneCode: '972',
    flag: '\ud83c\uddee\ud83c\uddf1',
    countryCode: 'IL',
    countryName: 'Israel'
  },
  {
    phoneCode: '39',
    flag: '\ud83c\uddee\ud83c\uddf9',
    countryCode: 'IT',
    countryName: 'Italy'
  },
  {
    phoneCode: '1876',
    flag: '\ud83c\uddef\ud83c\uddf2',
    countryCode: 'JM',
    countryName: 'Jamaica'
  },
  {
    phoneCode: '81',
    flag: '\ud83c\uddef\ud83c\uddf5',
    countryCode: 'JP',
    countryName: 'Japan'
  },
  {
    phoneCode: '44',
    flag: '\ud83c\uddef\ud83c\uddea',
    countryCode: 'JE',
    countryName: 'Jersey'
  },
  {
    phoneCode: '962',
    flag: '\ud83c\uddef\ud83c\uddf4',
    countryCode: 'JO',
    countryName: 'Jordan'
  },
  {
    phoneCode: '7',
    flag: '\ud83c\uddf0\ud83c\uddff',
    countryCode: 'KZ',
    countryName: 'Kazakhstan'
  },
  {
    phoneCode: '254',
    flag: '\ud83c\uddf0\ud83c\uddea',
    countryCode: 'KE',
    countryName: 'Kenya'
  },
  {
    phoneCode: '686',
    flag: '\ud83c\uddf0\ud83c\uddee',
    countryCode: 'KI',
    countryName: 'Kiribati'
  },
  {
    phoneCode: '383',
    flag: '\ud83c\uddfd\ud83c\uddf0',
    countryCode: 'XK',
    countryName: 'Kosovo'
  },
  {
    phoneCode: '965',
    flag: '\ud83c\uddf0\ud83c\uddfc',
    countryCode: 'KW',
    countryName: 'Kuwait'
  },
  {
    phoneCode: '996',
    flag: '\ud83c\uddf0\ud83c\uddec',
    countryCode: 'KG',
    countryName: 'Kyrgyzstan'
  },
  {
    phoneCode: '856',
    flag: '\ud83c\uddf1\ud83c\udde6',
    countryCode: 'LA',
    countryName: 'Laos'
  },
  {
    phoneCode: '371',
    flag: '\ud83c\uddf1\ud83c\uddfb',
    countryCode: 'LV',
    countryName: 'Latvia'
  },
  {
    phoneCode: '961',
    flag: '\ud83c\uddf1\ud83c\udde7',
    countryCode: 'LB',
    countryName: 'Lebanon'
  },
  {
    phoneCode: '266',
    flag: '\ud83c\uddf1\ud83c\uddf8',
    countryCode: 'LS',
    countryName: 'Lesotho'
  },
  {
    phoneCode: '231',
    flag: '\ud83c\uddf1\ud83c\uddf7',
    countryCode: 'LR',
    countryName: 'Liberia'
  },
  {
    phoneCode: '218',
    flag: '\ud83c\uddf1\ud83c\uddfe',
    countryCode: 'LY',
    countryName: 'Libyan Arab Jamahiriya'
  },
  {
    phoneCode: '423',
    flag: '\ud83c\uddf1\ud83c\uddee',
    countryCode: 'LI',
    countryName: 'Liechtenstein'
  },
  {
    phoneCode: '370',
    flag: '\ud83c\uddf1\ud83c\uddf9',
    countryCode: 'LT',
    countryName: 'Lithuania'
  },
  {
    phoneCode: '352',
    flag: '\ud83c\uddf1\ud83c\uddfa',
    countryCode: 'LU',
    countryName: 'Luxembourg'
  },
  {
    phoneCode: '853',
    flag: '\ud83c\uddf2\ud83c\uddf4',
    countryCode: 'MO',
    countryName: 'Macao'
  },
  {
    phoneCode: '261',
    flag: '\ud83c\uddf2\ud83c\uddec',
    countryCode: 'MG',
    countryName: 'Madagascar'
  },
  {
    phoneCode: '265',
    flag: '\ud83c\uddf2\ud83c\uddfc',
    countryCode: 'MW',
    countryName: 'Malawi'
  },
  {
    phoneCode: '60',
    flag: '\ud83c\uddf2\ud83c\uddfe',
    countryCode: 'MY',
    countryName: 'Malaysia'
  },
  {
    phoneCode: '960',
    flag: '\ud83c\uddf2\ud83c\uddfb',
    countryCode: 'MV',
    countryName: 'Maldives'
  },
  {
    phoneCode: '223',
    flag: '\ud83c\uddf2\ud83c\uddf1',
    countryCode: 'ML',
    countryName: 'Mali'
  },
  {
    phoneCode: '356',
    flag: '\ud83c\uddf2\ud83c\uddf9',
    countryCode: 'MT',
    countryName: 'Malta'
  },
  {
    phoneCode: '692',
    flag: '\ud83c\uddf2\ud83c\udded',
    countryCode: 'MH',
    countryName: 'Marshall Islands'
  },
  {
    phoneCode: '596',
    flag: '\ud83c\uddf2\ud83c\uddf6',
    countryCode: 'MQ',
    countryName: 'Martinique'
  },
  {
    phoneCode: '222',
    flag: '\ud83c\uddf2\ud83c\uddf7',
    countryCode: 'MR',
    countryName: 'Mauritania'
  },
  {
    phoneCode: '230',
    flag: '\ud83c\uddf2\ud83c\uddfa',
    countryCode: 'MU',
    countryName: 'Mauritius'
  },
  {
    phoneCode: '262',
    flag: '\ud83c\uddfe\ud83c\uddf9',
    countryCode: 'YT',
    countryName: 'Mayotte'
  },
  {
    phoneCode: '52',
    flag: '\ud83c\uddf2\ud83c\uddfd',
    countryCode: 'MX',
    countryName: 'Mexico'
  },
  {
    phoneCode: '691',
    flag: '\ud83c\uddeb\ud83c\uddf2',
    countryCode: 'FM',
    countryName: 'Micronesia'
  },
  {
    phoneCode: '373',
    flag: '\ud83c\uddf2\ud83c\udde9',
    countryCode: 'MD',
    countryName: 'Moldova'
  },
  {
    phoneCode: '377',
    flag: '\ud83c\uddf2\ud83c\udde8',
    countryCode: 'MC',
    countryName: 'Monaco'
  },
  {
    phoneCode: '976',
    flag: '\ud83c\uddf2\ud83c\uddf3',
    countryCode: 'MN',
    countryName: 'Mongolia'
  },
  {
    phoneCode: '382',
    flag: '\ud83c\uddf2\ud83c\uddea',
    countryCode: 'ME',
    countryName: 'Montenegro'
  },
  {
    phoneCode: '1664',
    flag: '\ud83c\uddf2\ud83c\uddf8',
    countryCode: 'MS',
    countryName: 'Montserrat'
  },
  {
    phoneCode: '212',
    flag: '\ud83c\uddf2\ud83c\udde6',
    countryCode: 'MA',
    countryName: 'Morocco'
  },
  {
    phoneCode: '258',
    flag: '\ud83c\uddf2\ud83c\uddff',
    countryCode: 'MZ',
    countryName: 'Mozambique'
  },
  {
    phoneCode: '95',
    flag: '\ud83c\uddf2\ud83c\uddf2',
    countryCode: 'MM',
    countryName: 'Myanmar'
  },
  {
    phoneCode: '264',
    flag: '\ud83c\uddf3\ud83c\udde6',
    countryCode: 'NA',
    countryName: 'Namibia'
  },
  {
    phoneCode: '674',
    flag: '\ud83c\uddf3\ud83c\uddf7',
    countryCode: 'NR',
    countryName: 'Nauru'
  },
  {
    phoneCode: '977',
    flag: '\ud83c\uddf3\ud83c\uddf5',
    countryCode: 'NP',
    countryName: 'Nepal'
  },
  {
    phoneCode: '31',
    flag: '\ud83c\uddf3\ud83c\uddf1',
    countryCode: 'NL',
    countryName: 'Netherlands'
  },
  {
    phoneCode: '599',
    flag: '',
    countryCode: 'AN',
    countryName: 'Netherlands Antilles'
  },
  {
    phoneCode: '687',
    flag: '\ud83c\uddf3\ud83c\udde8',
    countryCode: 'NC',
    countryName: 'New Caledonia'
  },
  {
    phoneCode: '64',
    flag: '\ud83c\uddf3\ud83c\uddff',
    countryCode: 'NZ',
    countryName: 'New Zealand'
  },
  {
    phoneCode: '505',
    flag: '\ud83c\uddf3\ud83c\uddee',
    countryCode: 'NI',
    countryName: 'Nicaragua'
  },
  {
    phoneCode: '227',
    flag: '\ud83c\uddf3\ud83c\uddea',
    countryCode: 'NE',
    countryName: 'Niger'
  },
  {
    phoneCode: '234',
    flag: '\ud83c\uddf3\ud83c\uddec',
    countryCode: 'NG',
    countryName: 'Nigeria'
  },
  {
    phoneCode: '683',
    flag: '\ud83c\uddf3\ud83c\uddfa',
    countryCode: 'NU',
    countryName: 'Niue'
  },
  {
    phoneCode: '672',
    flag: '\ud83c\uddf3\ud83c\uddeb',
    countryCode: 'NF',
    countryName: 'Norfolk Island'
  },
  {
    phoneCode: '850',
    flag: '\ud83c\uddf0\ud83c\uddf5',
    countryCode: 'KP',
    countryName: 'North Korea'
  },
  {
    phoneCode: '389',
    flag: '\ud83c\uddf2\ud83c\uddf0',
    countryCode: 'MK',
    countryName: 'North Macedonia'
  },
  {
    phoneCode: '1670',
    flag: '\ud83c\uddf2\ud83c\uddf5',
    countryCode: 'MP',
    countryName: 'Northern Mariana Islands'
  },
  {
    phoneCode: '47',
    flag: '\ud83c\uddf3\ud83c\uddf4',
    countryCode: 'NO',
    countryName: 'Norway'
  },
  {
    phoneCode: '968',
    flag: '\ud83c\uddf4\ud83c\uddf2',
    countryCode: 'OM',
    countryName: 'Oman'
  },
  {
    phoneCode: '92',
    flag: '\ud83c\uddf5\ud83c\uddf0',
    countryCode: 'PK',
    countryName: 'Pakistan'
  },
  {
    phoneCode: '680',
    flag: '\ud83c\uddf5\ud83c\uddfc',
    countryCode: 'PW',
    countryName: 'Palau'
  },
  {
    phoneCode: '970',
    flag: '\ud83c\uddf5\ud83c\uddf8',
    countryCode: 'PS',
    countryName: 'Palestinian Territory, Occupied'
  },
  {
    phoneCode: '507',
    flag: '\ud83c\uddf5\ud83c\udde6',
    countryCode: 'PA',
    countryName: 'Panama'
  },
  {
    phoneCode: '675',
    flag: '\ud83c\uddf5\ud83c\uddec',
    countryCode: 'PG',
    countryName: 'Papua New Guinea'
  },
  {
    phoneCode: '595',
    flag: '\ud83c\uddf5\ud83c\uddfe',
    countryCode: 'PY',
    countryName: 'Paraguay'
  },
  {
    phoneCode: '51',
    flag: '\ud83c\uddf5\ud83c\uddea',
    countryCode: 'PE',
    countryName: 'Peru'
  },
  {
    phoneCode: '63',
    flag: '\ud83c\uddf5\ud83c\udded',
    countryCode: 'PH',
    countryName: 'Philippines'
  },
  {
    phoneCode: '64',
    flag: '\ud83c\uddf5\ud83c\uddf3',
    countryCode: 'PN',
    countryName: 'Pitcairn'
  },
  {
    phoneCode: '48',
    flag: '\ud83c\uddf5\ud83c\uddf1',
    countryCode: 'PL',
    countryName: 'Poland'
  },
  {
    phoneCode: '351',
    flag: '\ud83c\uddf5\ud83c\uddf9',
    countryCode: 'PT',
    countryName: 'Portugal'
  },
  {
    phoneCode: '1939',
    flag: '\ud83c\uddf5\ud83c\uddf7',
    countryCode: 'PR',
    countryName: 'Puerto Rico'
  },
  {
    phoneCode: '974',
    flag: '\ud83c\uddf6\ud83c\udde6',
    countryCode: 'QA',
    countryName: 'Qatar'
  },
  {
    phoneCode: '262',
    flag: '\ud83c\uddf7\ud83c\uddea',
    countryCode: 'RE',
    countryName: 'Reunion'
  },
  {
    phoneCode: '40',
    flag: '\ud83c\uddf7\ud83c\uddf4',
    countryCode: 'RO',
    countryName: 'Romania'
  },
  {
    phoneCode: '7',
    flag: '\ud83c\uddf7\ud83c\uddfa',
    countryCode: 'RU',
    countryName: 'Russia'
  },
  {
    phoneCode: '250',
    flag: '\ud83c\uddf7\ud83c\uddfc',
    countryCode: 'RW',
    countryName: 'Rwanda'
  },
  {
    phoneCode: '590',
    flag: '\ud83c\udde7\ud83c\uddf1',
    countryCode: 'BL',
    countryName: 'Saint Barthelemy'
  },
  {
    phoneCode: '290',
    flag: '\ud83c\uddf8\ud83c\udded',
    countryCode: 'SH',
    countryName: 'Saint Helena, Ascension and Tristan Da Cunha'
  },
  {
    phoneCode: '1869',
    flag: '\ud83c\uddf0\ud83c\uddf3',
    countryCode: 'KN',
    countryName: 'Saint Kitts and Nevis'
  },
  {
    phoneCode: '1758',
    flag: '\ud83c\uddf1\ud83c\udde8',
    countryCode: 'LC',
    countryName: 'Saint Lucia'
  },
  {
    phoneCode: '590',
    flag: '\ud83c\uddf2\ud83c\uddeb',
    countryCode: 'MF',
    countryName: 'Saint Martin'
  },
  {
    phoneCode: '508',
    flag: '\ud83c\uddf5\ud83c\uddf2',
    countryCode: 'PM',
    countryName: 'Saint Pierre and Miquelon'
  },
  {
    phoneCode: '1784',
    flag: '\ud83c\uddfb\ud83c\udde8',
    countryCode: 'VC',
    countryName: 'Saint Vincent and the Grenadines'
  },
  {
    phoneCode: '685',
    flag: '\ud83c\uddfc\ud83c\uddf8',
    countryCode: 'WS',
    countryName: 'Samoa'
  },
  {
    phoneCode: '378',
    flag: '\ud83c\uddf8\ud83c\uddf2',
    countryCode: 'SM',
    countryName: 'San Marino'
  },
  {
    phoneCode: '239',
    flag: '\ud83c\uddf8\ud83c\uddf9',
    countryCode: 'ST',
    countryName: 'Sao Tome and Principe'
  },
  {
    phoneCode: '966',
    flag: '\ud83c\uddf8\ud83c\udde6',
    countryCode: 'SA',
    countryName: 'Saudi Arabia'
  },
  {
    phoneCode: '221',
    flag: '\ud83c\uddf8\ud83c\uddf3',
    countryCode: 'SN',
    countryName: 'Senegal'
  },
  {
    phoneCode: '381',
    flag: '\ud83c\uddf7\ud83c\uddf8',
    countryCode: 'RS',
    countryName: 'Serbia'
  },
  {
    phoneCode: '248',
    flag: '\ud83c\uddf8\ud83c\udde8',
    countryCode: 'SC',
    countryName: 'Seychelles'
  },
  {
    phoneCode: '232',
    flag: '\ud83c\uddf8\ud83c\uddf1',
    countryCode: 'SL',
    countryName: 'Sierra Leone'
  },
  {
    phoneCode: '65',
    flag: '\ud83c\uddf8\ud83c\uddec',
    countryCode: 'SG',
    countryName: 'Singapore'
  },
  {
    phoneCode: '421',
    flag: '\ud83c\uddf8\ud83c\uddf0',
    countryCode: 'SK',
    countryName: 'Slovakia'
  },
  {
    phoneCode: '386',
    flag: '\ud83c\uddf8\ud83c\uddee',
    countryCode: 'SI',
    countryName: 'Slovenia'
  },
  {
    phoneCode: '677',
    flag: '\ud83c\uddf8\ud83c\udde7',
    countryCode: 'SB',
    countryName: 'Solomon Islands'
  },
  {
    phoneCode: '252',
    flag: '\ud83c\uddf8\ud83c\uddf4',
    countryCode: 'SO',
    countryName: 'Somalia'
  },
  {
    phoneCode: '27',
    flag: '\ud83c\uddff\ud83c\udde6',
    countryCode: 'ZA',
    countryName: 'South Africa'
  },
  {
    phoneCode: '500',
    flag: '\ud83c\uddec\ud83c\uddf8',
    countryCode: 'GS',
    countryName: 'South Georgia and the South Sandwich Islands'
  },
  {
    phoneCode: '82',
    flag: '\ud83c\uddf0\ud83c\uddf7',
    countryCode: 'KR',
    countryName: 'South Korea'
  },
  {
    phoneCode: '211',
    flag: '\ud83c\uddf8\ud83c\uddf8',
    countryCode: 'SS',
    countryName: 'South Sudan'
  },
  {
    phoneCode: '34',
    flag: '\ud83c\uddea\ud83c\uddf8',
    countryCode: 'ES',
    countryName: 'Spain'
  },
  {
    phoneCode: '94',
    flag: '\ud83c\uddf1\ud83c\uddf0',
    countryCode: 'LK',
    countryName: 'Sri Lanka'
  },
  {
    phoneCode: '249',
    flag: '\ud83c\uddf8\ud83c\udde9',
    countryCode: 'SD',
    countryName: 'Sudan'
  },
  {
    phoneCode: '597',
    flag: '\ud83c\uddf8\ud83c\uddf7',
    countryCode: 'SR',
    countryName: 'Suriname'
  },
  {
    phoneCode: '47',
    flag: '\ud83c\uddf8\ud83c\uddef',
    countryCode: 'SJ',
    countryName: 'Svalbard and Jan Mayen'
  },
  {
    phoneCode: '268',
    flag: '\ud83c\uddf8\ud83c\uddff',
    countryCode: 'SZ',
    countryName: 'Swaziland'
  },
  {
    phoneCode: '46',
    flag: '\ud83c\uddf8\ud83c\uddea',
    countryCode: 'SE',
    countryName: 'Sweden'
  },
  {
    phoneCode: '41',
    flag: '\ud83c\udde8\ud83c\udded',
    countryCode: 'CH',
    countryName: 'Switzerland'
  },
  {
    phoneCode: '963',
    flag: '\ud83c\uddf8\ud83c\uddfe',
    countryCode: 'SY',
    countryName: 'Syrian Arab Republic'
  },
  {
    phoneCode: '886',
    flag: '\ud83c\uddf9\ud83c\uddfc',
    countryCode: 'TW',
    countryName: 'Taiwan'
  },
  {
    phoneCode: '992',
    flag: '\ud83c\uddf9\ud83c\uddef',
    countryCode: 'TJ',
    countryName: 'Tajikistan'
  },
  {
    phoneCode: '255',
    flag: '\ud83c\uddf9\ud83c\uddff',
    countryCode: 'TZ',
    countryName: 'Tanzania'
  },
  {
    phoneCode: '66',
    flag: '\ud83c\uddf9\ud83c\udded',
    countryCode: 'TH',
    countryName: 'Thailand'
  },
  {
    phoneCode: '670',
    flag: '\ud83c\uddf9\ud83c\uddf1',
    countryCode: 'TL',
    countryName: 'Timor-Leste'
  },
  {
    phoneCode: '228',
    flag: '\ud83c\uddf9\ud83c\uddec',
    countryCode: 'TG',
    countryName: 'Togo'
  },
  {
    phoneCode: '690',
    flag: '\ud83c\uddf9\ud83c\uddf0',
    countryCode: 'TK',
    countryName: 'Tokelau'
  },
  {
    phoneCode: '676',
    flag: '\ud83c\uddf9\ud83c\uddf4',
    countryCode: 'TO',
    countryName: 'Tonga'
  },
  {
    phoneCode: '1868',
    flag: '\ud83c\uddf9\ud83c\uddf9',
    countryCode: 'TT',
    countryName: 'Trinidad and Tobago'
  },
  {
    phoneCode: '216',
    flag: '\ud83c\uddf9\ud83c\uddf3',
    countryCode: 'TN',
    countryName: 'Tunisia'
  },
  {
    phoneCode: '993',
    flag: '\ud83c\uddf9\ud83c\uddf2',
    countryCode: 'TM',
    countryName: 'Turkmenistan'
  },
  {
    phoneCode: '1649',
    flag: '\ud83c\uddf9\ud83c\udde8',
    countryCode: 'TC',
    countryName: 'Turks and Caicos Islands'
  },
  {
    phoneCode: '688',
    flag: '\ud83c\uddf9\ud83c\uddfb',
    countryCode: 'TV',
    countryName: 'Tuvalu'
  },
  {
    phoneCode: '90',
    flag: '\ud83c\uddf9\ud83c\uddf7',
    countryCode: 'TR',
    countryName: 'Turkey'
  },
  {
    phoneCode: '256',
    flag: '\ud83c\uddfa\ud83c\uddec',
    countryCode: 'UG',
    countryName: 'Uganda'
  },
  {
    phoneCode: '380',
    flag: '\ud83c\uddfa\ud83c\udde6',
    countryCode: 'UA',
    countryName: 'Ukraine'
  },
  {
    phoneCode: '971',
    flag: '\ud83c\udde6\ud83c\uddea',
    countryCode: 'AE',
    countryName: 'United Arab Emirates'
  },
  {
    phoneCode: '44',
    flag: '\ud83c\uddec\ud83c\udde7',
    countryCode: 'GB',
    countryName: 'United Kingdom'
  },
  {
    phoneCode: '598',
    flag: '\ud83c\uddfa\ud83c\uddfe',
    countryCode: 'UY',
    countryName: 'Uruguay'
  },
  {
    phoneCode: '998',
    flag: '\ud83c\uddfa\ud83c\uddff',
    countryCode: 'UZ',
    countryName: 'Uzbekistan'
  },
  {
    phoneCode: '678',
    flag: '\ud83c\uddfb\ud83c\uddfa',
    countryCode: 'VU',
    countryName: 'Vanuatu'
  },
  {
    phoneCode: '58',
    flag: '\ud83c\uddfb\ud83c\uddea',
    countryCode: 'VE',
    countryName: 'Venezuela'
  },
  {
    phoneCode: '84',
    flag: '\ud83c\uddfb\ud83c\uddf3',
    countryCode: 'VN',
    countryName: 'Vietnam'
  },
  {
    phoneCode: '1284',
    flag: '\ud83c\uddfb\ud83c\uddec',
    countryCode: 'VG',
    countryName: 'Virgin Islands, British'
  },
  {
    phoneCode: '1340',
    flag: '\ud83c\uddfb\ud83c\uddee',
    countryCode: 'VI',
    countryName: 'Virgin Islands, U.S.'
  },
  {
    phoneCode: '681',
    flag: '\ud83c\uddfc\ud83c\uddeb',
    countryCode: 'WF',
    countryName: 'Wallis and Futuna'
  },
  {
    phoneCode: '967',
    flag: '\ud83c\uddfe\ud83c\uddea',
    countryCode: 'YE',
    countryName: 'Yemen'
  },
  {
    phoneCode: '260',
    flag: '\ud83c\uddff\ud83c\uddf2',
    countryCode: 'ZM',
    countryName: 'Zambia'
  },
  {
    phoneCode: '263',
    flag: '\ud83c\uddff\ud83c\uddfc',
    countryCode: 'ZW',
    countryName: 'Zimbabwe'
  },
  {
    phoneCode: '358',
    flag: '\ud83c\udde6\ud83c\uddfd',
    countryCode: 'AX',
    countryName: '\u00c5land Islands'
  }
];

export default countryData;

// https://firebase.google.com/support/faq/#phone-auth-countries
export const firebaseSMSCountries = new Set([
  'AD',
  'AE',
  'AF',
  'AG',
  'AL',
  'AM',
  'AO',
  'AR',
  'AS',
  'AT',
  'AU',
  'AW',
  'AZ',
  'BA',
  'BB',
  'BD',
  'BE',
  'BF',
  'BG',
  'BJ',
  'BM',
  'BN',
  'BO',
  'BR',
  'BS',
  'BT',
  'BW',
  'BY',
  'BZ',
  'CA',
  'CD',
  'CF',
  'CG',
  'CH',
  'CI',
  'CK',
  'CL',
  'CM',
  'CO',
  'CR',
  'CV',
  'CW',
  'CY',
  'CZ',
  'DE',
  'DJ',
  'DK',
  'DM',
  'DO',
  'DZ',
  'EC',
  'EG',
  'ES',
  'ET',
  'FI',
  'FJ',
  'FK',
  'FM',
  'FO',
  'FR',
  'GA',
  'GB',
  'GD',
  'GE',
  'GF',
  'GG',
  'GH',
  'GI',
  'GL',
  'GM',
  'GP',
  'GQ',
  'GR',
  'GT',
  'GY',
  'HK',
  'HN',
  'HR',
  'HT',
  'HU',
  'ID',
  'IE',
  'IL',
  'IM',
  'IN',
  'IQ',
  'IT',
  'JE',
  'JM',
  'JO',
  'JP',
  'KE',
  'KG',
  'KH',
  'KM',
  'KN',
  'KR',
  'KW',
  'KY',
  'KZ',
  'LA',
  'LB',
  'LC',
  'LI',
  'LK',
  'LS',
  'LT',
  'LU',
  'LV',
  'LY',
  'MA',
  'MD',
  'ME',
  'MF',
  'MG',
  'MK',
  'MM',
  'MN',
  'MO',
  'MS',
  'MT',
  'MU',
  'MW',
  'MX',
  'MY',
  'MZ',
  'NA',
  'NC',
  'NE',
  'NF',
  'NG',
  'NI',
  'NL',
  'NO',
  'NP',
  'NZ',
  'OM',
  'PA',
  'PE',
  'PG',
  'PH',
  'PK',
  'PL',
  'PM',
  'PR',
  'PS',
  'PT',
  'PY',
  'QA',
  'RE',
  'RO',
  'RS',
  'RU',
  'RW',
  'SA',
  'SC',
  'SE',
  'SG',
  'SH',
  'SI',
  'SK',
  'SL',
  'SN',
  'SR',
  'ST',
  'SV',
  'SZ',
  'TC',
  'TG',
  'TH',
  'TL',
  'TM',
  'TO',
  'TR',
  'TT',
  'TW',
  'TZ',
  'UA',
  'UG',
  'US',
  'UY',
  'UZ',
  'VC',
  'VE',
  'VG',
  'VI',
  'VN',
  'WS',
  'YE',
  'YT',
  'ZA',
  'ZM',
  'ZW'
]);

export function findCountryByID(id: string, idType = 'code') {
  const key = idType === 'code' ? 'countryCode' : 'countryName';
  return countryData.find((country) => country[key] === id);
}
